/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

export const enum DiffType {
  Insert = 'Insert',
  Delete = 'Delete',
  Equal = 'Equal'
}
export interface DiffChunk {
  diffType: DiffType
  text: string
}
export interface CommitData {
  sha: string
  date: number
  message: string
  author: string
  parents: Array<string>
  files: Array<CommitFile>
}
export interface CommitFile {
  from: string
  to: string
  additions: number
  deletions: number
  status: CommitFileStatus
}
export const enum CommitFileStatus {
  Added = 0,
  Deleted = 1,
  Modified = 2,
  Renamed = 3
}
export const enum CommitChainGetFiles {
  DoGetFiles = 0,
  DontGetFiles = 1
}
export interface VerifyData {
  commitTime: number
  fileContent: string
  filePath: string
}
export class DiffClient {
  constructor()
  diff(text1: string, text2: string): Array<DiffChunk>
  /**
   * use https://docs.rs/diffmatchpatch/latest/diffmatchpatch/struct.DiffMatchPatch.html#method.diff_lines_to_chars
   * then diff the chars.
   * then convert back to lines.
   *
   * takes in two strings. splits based on newlines.
   * returns diffs based on lines.
   */
  diffLines(text1: string, text2: string): Array<DiffChunk>
}
export class MerkleClient {
  constructor(absoluteRootDirectory: string)
  isTooBig(maxFiles: number, gitIgnoredFiles: Array<string>, isGitRepo: boolean): Promise<boolean>
  init(gitIgnoredFiles: Array<string>, isGitRepo: boolean): Promise<void>
  initWithRipgrepIgnore(): Promise<void>
  computeMerkleTreeWithRipgrepIgnore(): Promise<void>
  computeMerkleTree(gitIgnoredFiles: Array<string>, isGitRepo: boolean): Promise<void>
  updateFile(filePath: string): Promise<void>
  deleteFile(filePath: string): Promise<void>
  getSubtreeHash(relativePath: string): Promise<string>
  getNumEmbeddableFiles(): Promise<number>
  getImportantPaths(k: number): Promise<Array<string>>
  getAllFiles(): Promise<Array<string>>
  getAllDirFilesToEmbed(absoluteFilePath: string): Promise<Array<string>>
  getNextFileToEmbed(): Promise<Array<string>>
  getSpline(absoluteFilePath: string): Promise<Array<string>>
  getHashesForFiles(files: Array<string>): Promise<Array<string>>
  updateRootDirectory(rootDirectory: string): void
}
export class GitClient {
  constructor(absoluteRootDirectory: string)
  getTotalCommitCount(): Promise<number>
  getCommitVerifyData(commit: string): Promise<VerifyData>
  throwIfCommitDoesntExist(rootSha: string): Promise<void>
  getVerifyCommit(): Promise<string>
  getRepoHeadSha(): Promise<string | null>
  getCommitChain(hash: string, depth: number, getFiles: CommitChainGetFiles): Promise<Array<CommitData>>
}
