#!/bin/bash

set -e

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"
PRODUCT_JSON_PATH="$SCRIPT_DIR/../../../../product.json"

PRODUCT_JSON_HASH=$(sha256sum $PRODUCT_JSON_PATH | awk '{ print $1 }')

echo "PRODUCT_JSON_HASH: $PRODUCT_JSON_HASH"

echo "//registry.npmjs.org/:_authToken=$NPM_TOKEN" >> ~/.npmrc
VERSION="0.0.0-$(git rev-parse --short=8 HEAD)-$PRODUCT_JSON_HASH"
echo "Checking npm view works"

NPM_VIEW_HELP=$(npm view --help 2>/dev/null)
if [ $? -eq 0 ]; then
  echo "npm view --help command executed successfully"
else
  echo "npm view --help command failed"
  exit 1
fi

echo "checking if version $VERSION already exists"
EXISTS=$(npm view @anysphere/file-service@$VERSION version 2>/dev/null || echo '')

if [ -z "$EXISTS" ]; then
  echo "Publishing version $VERSION"
  yarn version --no-git-tag-version --new-version $VERSION
  npm publish --access public --tag next --scope @anysphere
else
  echo "Version $VERSION already exists. Skipping publish."
fi