"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.setSpanWithError = exports.setResponseContentLengthAttribute = exports.setRequestContentLengthAttribute = exports.setAttributesFromHttpKind = exports.satisfiesPattern = exports.parseResponseStatus = exports.isValidOptionsType = exports.isIgnored = exports.isCompressed = exports.headerCapture = exports.getRequestInfo = exports.getOutgoingRequestMetricAttributesOnResponse = exports.getOutgoingRequestMetricAttributes = exports.getOutgoingRequestAttributesOnResponse = exports.getOutgoingRequestAttributes = exports.getIncomingRequestMetricAttributesOnResponse = exports.getIncomingRequestMetricAttributes = exports.getIncomingRequestAttributesOnResponse = exports.getIncomingRequestAttributes = exports.getAbsoluteUrl = exports.extractHostnameAndPort = exports.HttpInstrumentation = void 0;
var http_1 = require("./http");
Object.defineProperty(exports, "HttpInstrumentation", { enumerable: true, get: function () { return http_1.HttpInstrumentation; } });
var utils_1 = require("./utils");
Object.defineProperty(exports, "extractHostnameAndPort", { enumerable: true, get: function () { return utils_1.extractHostnameAndPort; } });
Object.defineProperty(exports, "getAbsoluteUrl", { enumerable: true, get: function () { return utils_1.getAbsoluteUrl; } });
Object.defineProperty(exports, "getIncomingRequestAttributes", { enumerable: true, get: function () { return utils_1.getIncomingRequestAttributes; } });
Object.defineProperty(exports, "getIncomingRequestAttributesOnResponse", { enumerable: true, get: function () { return utils_1.getIncomingRequestAttributesOnResponse; } });
Object.defineProperty(exports, "getIncomingRequestMetricAttributes", { enumerable: true, get: function () { return utils_1.getIncomingRequestMetricAttributes; } });
Object.defineProperty(exports, "getIncomingRequestMetricAttributesOnResponse", { enumerable: true, get: function () { return utils_1.getIncomingRequestMetricAttributesOnResponse; } });
Object.defineProperty(exports, "getOutgoingRequestAttributes", { enumerable: true, get: function () { return utils_1.getOutgoingRequestAttributes; } });
Object.defineProperty(exports, "getOutgoingRequestAttributesOnResponse", { enumerable: true, get: function () { return utils_1.getOutgoingRequestAttributesOnResponse; } });
Object.defineProperty(exports, "getOutgoingRequestMetricAttributes", { enumerable: true, get: function () { return utils_1.getOutgoingRequestMetricAttributes; } });
Object.defineProperty(exports, "getOutgoingRequestMetricAttributesOnResponse", { enumerable: true, get: function () { return utils_1.getOutgoingRequestMetricAttributesOnResponse; } });
Object.defineProperty(exports, "getRequestInfo", { enumerable: true, get: function () { return utils_1.getRequestInfo; } });
Object.defineProperty(exports, "headerCapture", { enumerable: true, get: function () { return utils_1.headerCapture; } });
Object.defineProperty(exports, "isCompressed", { enumerable: true, get: function () { return utils_1.isCompressed; } });
Object.defineProperty(exports, "isIgnored", { enumerable: true, get: function () { return utils_1.isIgnored; } });
Object.defineProperty(exports, "isValidOptionsType", { enumerable: true, get: function () { return utils_1.isValidOptionsType; } });
Object.defineProperty(exports, "parseResponseStatus", { enumerable: true, get: function () { return utils_1.parseResponseStatus; } });
Object.defineProperty(exports, "satisfiesPattern", { enumerable: true, get: function () { return utils_1.satisfiesPattern; } });
Object.defineProperty(exports, "setAttributesFromHttpKind", { enumerable: true, get: function () { return utils_1.setAttributesFromHttpKind; } });
Object.defineProperty(exports, "setRequestContentLengthAttribute", { enumerable: true, get: function () { return utils_1.setRequestContentLengthAttribute; } });
Object.defineProperty(exports, "setResponseContentLengthAttribute", { enumerable: true, get: function () { return utils_1.setResponseContentLengthAttribute; } });
Object.defineProperty(exports, "setSpanWithError", { enumerable: true, get: function () { return utils_1.setSpanWithError; } });