"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Span = exports.SamplingDecision = exports.TraceIdRatioBasedSampler = exports.ParentBasedSampler = exports.AlwaysOnSampler = exports.AlwaysOffSampler = exports.NoopSpanProcessor = exports.SimpleSpanProcessor = exports.InMemorySpanExporter = exports.ConsoleSpanExporter = exports.RandomIdGenerator = exports.BatchSpanProcessor = exports.ForceFlushState = exports.BasicTracerProvider = exports.Tracer = void 0;
var Tracer_1 = require("./Tracer");
Object.defineProperty(exports, "Tracer", { enumerable: true, get: function () { return Tracer_1.Tracer; } });
var BasicTracerProvider_1 = require("./BasicTracerProvider");
Object.defineProperty(exports, "BasicTracerProvider", { enumerable: true, get: function () { return BasicTracerProvider_1.BasicTracerProvider; } });
Object.defineProperty(exports, "ForceFlushState", { enumerable: true, get: function () { return BasicTracerProvider_1.ForceFlushState; } });
var platform_1 = require("./platform");
Object.defineProperty(exports, "BatchSpanProcessor", { enumerable: true, get: function () { return platform_1.BatchSpanProcessor; } });
Object.defineProperty(exports, "RandomIdGenerator", { enumerable: true, get: function () { return platform_1.RandomIdGenerator; } });
var ConsoleSpanExporter_1 = require("./export/ConsoleSpanExporter");
Object.defineProperty(exports, "ConsoleSpanExporter", { enumerable: true, get: function () { return ConsoleSpanExporter_1.ConsoleSpanExporter; } });
var InMemorySpanExporter_1 = require("./export/InMemorySpanExporter");
Object.defineProperty(exports, "InMemorySpanExporter", { enumerable: true, get: function () { return InMemorySpanExporter_1.InMemorySpanExporter; } });
var SimpleSpanProcessor_1 = require("./export/SimpleSpanProcessor");
Object.defineProperty(exports, "SimpleSpanProcessor", { enumerable: true, get: function () { return SimpleSpanProcessor_1.SimpleSpanProcessor; } });
var NoopSpanProcessor_1 = require("./export/NoopSpanProcessor");
Object.defineProperty(exports, "NoopSpanProcessor", { enumerable: true, get: function () { return NoopSpanProcessor_1.NoopSpanProcessor; } });
var AlwaysOffSampler_1 = require("./sampler/AlwaysOffSampler");
Object.defineProperty(exports, "AlwaysOffSampler", { enumerable: true, get: function () { return AlwaysOffSampler_1.AlwaysOffSampler; } });
var AlwaysOnSampler_1 = require("./sampler/AlwaysOnSampler");
Object.defineProperty(exports, "AlwaysOnSampler", { enumerable: true, get: function () { return AlwaysOnSampler_1.AlwaysOnSampler; } });
var ParentBasedSampler_1 = require("./sampler/ParentBasedSampler");
Object.defineProperty(exports, "ParentBasedSampler", { enumerable: true, get: function () { return ParentBasedSampler_1.ParentBasedSampler; } });
var TraceIdRatioBasedSampler_1 = require("./sampler/TraceIdRatioBasedSampler");
Object.defineProperty(exports, "TraceIdRatioBasedSampler", { enumerable: true, get: function () { return TraceIdRatioBasedSampler_1.TraceIdRatioBasedSampler; } });
var Sampler_1 = require("./Sampler");
Object.defineProperty(exports, "SamplingDecision", { enumerable: true, get: function () { return Sampler_1.SamplingDecision; } });
var Span_1 = require("./Span");
Object.defineProperty(exports, "Span", { enumerable: true, get: function () { return Span_1.Span; } });