var {
  _optionalChain,
  _optionalChainDelete
} = require('@sentry/utils');

Object.defineProperty(exports, '__esModule', { value: true });

const node_worker_threads = require('node:worker_threads');
const core = require('@sentry/core');
const utils = require('@sentry/utils');
const nodeVersion = require('../../nodeVersion.js');

// This string is a placeholder that gets overwritten with the worker code.
const base64WorkerScript = 'LyohIEBzZW50cnkvbm9kZSA4LjM1LjAgKDRlMzNiNTQpIHwgaHR0cHM6Ly9naXRodWIuY29tL2dldHNlbnRyeS9zZW50cnktamF2YXNjcmlwdCAqLwppbXBvcnR7U2Vzc2lvbiBhcyB0fWZyb20ibm9kZTppbnNwZWN0b3IiO2ltcG9ydHtwYXJlbnRQb3J0IGFzIG4sd29ya2VyRGF0YSBhcyBlfWZyb20ibm9kZTp3b3JrZXJfdGhyZWFkcyI7aW1wb3J0e3Bvc2l4IGFzIHIsc2VwIGFzIG99ZnJvbSJub2RlOnBhdGgiO2ltcG9ydCphcyBzIGZyb20ibm9kZTpodHRwIjtpbXBvcnQqYXMgaSBmcm9tIm5vZGU6aHR0cHMiO2ltcG9ydHtSZWFkYWJsZSBhcyBjfWZyb20ibm9kZTpzdHJlYW0iO2ltcG9ydHtjcmVhdGVHemlwIGFzIHV9ZnJvbSJub2RlOnpsaWIiO2ltcG9ydCphcyBhIGZyb20ibm9kZTpuZXQiO2ltcG9ydCphcyBmIGZyb20ibm9kZTp0bHMiO2NvbnN0IGg9T2JqZWN0LnByb3RvdHlwZS50b1N0cmluZztmdW5jdGlvbiBwKHQsbil7cmV0dXJuIGguY2FsbCh0KT09PWBbb2JqZWN0ICR7bn1dYH1mdW5jdGlvbiBsKHQpe3JldHVybiBwKHQsIlN0cmluZyIpfWZ1bmN0aW9uIGQodCl7cmV0dXJuIHAodCwiT2JqZWN0Iil9ZnVuY3Rpb24gbSh0KXtyZXR1cm4gQm9vbGVhbih0JiZ0LnRoZW4mJiJmdW5jdGlvbiI9PXR5cGVvZiB0LnRoZW4pfWZ1bmN0aW9uIHkodCxuKXt0cnl7cmV0dXJuIHQgaW5zdGFuY2VvZiBufWNhdGNoKHQpe3JldHVybiExfX1jb25zdCBnPSI4LjM1LjAiLGI9Z2xvYmFsVGhpcztmdW5jdGlvbiBfKHQsbixlKXtjb25zdCByPWV8fGIsbz1yLl9fU0VOVFJZX189ci5fX1NFTlRSWV9ffHx7fSxzPW9bZ109b1tnXXx8e307cmV0dXJuIHNbdF18fChzW3RdPW4oKSl9Y29uc3Qgdj1iLHc9ODA7ZnVuY3Rpb24gUyh0LG4pe2NvbnN0IGU9dCxyPVtdO2lmKCFlfHwhZS50YWdOYW1lKXJldHVybiIiO2lmKHYuSFRNTEVsZW1lbnQmJmUgaW5zdGFuY2VvZiBIVE1MRWxlbWVudCYmZS5kYXRhc2V0KXtpZihlLmRhdGFzZXQuc2VudHJ5Q29tcG9uZW50KXJldHVybiBlLmRhdGFzZXQuc2VudHJ5Q29tcG9uZW50O2lmKGUuZGF0YXNldC5zZW50cnlFbGVtZW50KXJldHVybiBlLmRhdGFzZXQuc2VudHJ5RWxlbWVudH1yLnB1c2goZS50YWdOYW1lLnRvTG93ZXJDYXNlKCkpO2NvbnN0IG89biYmbi5sZW5ndGg/bi5maWx0ZXIoKHQ9PmUuZ2V0QXR0cmlidXRlKHQpKSkubWFwKCh0PT5bdCxlLmdldEF0dHJpYnV0ZSh0KV0pKTpudWxsO2lmKG8mJm8ubGVuZ3RoKW8uZm9yRWFjaCgodD0+e3IucHVzaChgWyR7dFswXX09IiR7dFsxXX0iXWApfSkpO2Vsc2V7ZS5pZCYmci5wdXNoKGAjJHtlLmlkfWApO2NvbnN0IHQ9ZS5jbGFzc05hbWU7aWYodCYmbCh0KSl7Y29uc3Qgbj10LnNwbGl0KC9ccysvKTtmb3IoY29uc3QgdCBvZiBuKXIucHVzaChgLiR7dH1gKX19Y29uc3Qgcz1bImFyaWEtbGFiZWwiLCJ0eXBlIiwibmFtZSIsInRpdGxlIiwiYWx0Il07Zm9yKGNvbnN0IHQgb2Ygcyl7Y29uc3Qgbj1lLmdldEF0dHJpYnV0ZSh0KTtuJiZyLnB1c2goYFske3R9PSIke259Il1gKX1yZXR1cm4gci5qb2luKCIiKX1jb25zdCAkPSJ1bmRlZmluZWQiPT10eXBlb2YgX19TRU5UUllfREVCVUdfX3x8X19TRU5UUllfREVCVUdfXyxFPVsiZGVidWciLCJpbmZvIiwid2FybiIsImVycm9yIiwibG9nIiwiYXNzZXJ0IiwidHJhY2UiXSx4PXt9O2Z1bmN0aW9uIE4odCl7aWYoISgiY29uc29sZSJpbiBiKSlyZXR1cm4gdCgpO2NvbnN0IG49Yi5jb25zb2xlLGU9e30scj1PYmplY3Qua2V5cyh4KTtyLmZvckVhY2goKHQ9Pntjb25zdCByPXhbdF07ZVt0XT1uW3RdLG5bdF09cn0pKTt0cnl7cmV0dXJuIHQoKX1maW5hbGx5e3IuZm9yRWFjaCgodD0+e25bdF09ZVt0XX0pKX19Y29uc3Qgaz1fKCJsb2dnZXIiLChmdW5jdGlvbigpe2xldCB0PSExO2NvbnN0IG49e2VuYWJsZTooKT0+e3Q9ITB9LGRpc2FibGU6KCk9Pnt0PSExfSxpc0VuYWJsZWQ6KCk9PnR9O3JldHVybiAkP0UuZm9yRWFjaCgoZT0+e25bZV09KC4uLm4pPT57dCYmTigoKCk9PntiLmNvbnNvbGVbZV0oYFNlbnRyeSBMb2dnZXIgWyR7ZX1dOmAsLi4ubil9KSl9fSkpOkUuZm9yRWFjaCgodD0+e25bdF09KCk9Pnt9fSkpLG59KSk7ZnVuY3Rpb24gQyh0LG49ITEpe2NvbnN0e2hvc3Q6ZSxwYXRoOnIscGFzczpvLHBvcnQ6cyxwcm9qZWN0SWQ6aSxwcm90b2NvbDpjLHB1YmxpY0tleTp1fT10O3JldHVybmAke2N9Oi8vJHt1fSR7biYmbz9gOiR7b31gOiIifUAke2V9JHtzP2A6JHtzfWA6IiJ9LyR7cj9gJHtyfS9gOnJ9JHtpfWB9Y2xhc3MgVCBleHRlbmRzIEVycm9ye2NvbnN0cnVjdG9yKHQsbj0id2FybiIpe3N1cGVyKHQpLHRoaXMubWVzc2FnZT10LHRoaXMubmFtZT1uZXcudGFyZ2V0LnByb3RvdHlwZS5jb25zdHJ1Y3Rvci5uYW1lLE9iamVjdC5zZXRQcm90b3R5cGVPZih0aGlzLG5ldy50YXJnZXQucHJvdG90eXBlKSx0aGlzLmxvZ0xldmVsPW59fWZ1bmN0aW9uIFIodCl7aWYoZnVuY3Rpb24odCl7c3dpdGNoKGguY2FsbCh0KSl7Y2FzZSJbb2JqZWN0IEVycm9yXSI6Y2FzZSJbb2JqZWN0IEV4Y2VwdGlvbl0iOmNhc2UiW29iamVjdCBET01FeGNlcHRpb25dIjpjYXNlIltvYmplY3QgV2ViQXNzZW1ibHkuRXhjZXB0aW9uXSI6cmV0dXJuITA7ZGVmYXVsdDpyZXR1cm4geSh0LEVycm9yKX19KHQpKXJldHVybnttZXNzYWdlOnQubWVzc2FnZSxuYW1lOnQubmFtZSxzdGFjazp0LnN0YWNrLC4uLmoodCl9O2lmKG49dCwidW5kZWZpbmVkIiE9dHlwZW9mIEV2ZW50JiZ5KG4sRXZlbnQpKXtjb25zdCBuPXt0eXBlOnQudHlwZSx0YXJnZXQ6RCh0LnRhcmdldCksY3VycmVudFRhcmdldDpEKHQuY3VycmVudFRhcmdldCksLi4uaih0KX07cmV0dXJuInVuZGVmaW5lZCIhPXR5cGVvZiBDdXN0b21FdmVudCYmeSh0LEN1c3RvbUV2ZW50KSYmKG4uZGV0YWlsPXQuZGV0YWlsKSxufXJldHVybiB0O3ZhciBufWZ1bmN0aW9uIEQodCl7dHJ5e3JldHVybiBuPXQsInVuZGVmaW5lZCIhPXR5cGVvZiBFbGVtZW50JiZ5KG4sRWxlbWVudCk/ZnVuY3Rpb24odCxuPXt9KXtpZighdClyZXR1cm4iPHVua25vd24+Ijt0cnl7bGV0IGU9dDtjb25zdCByPTUsbz1bXTtsZXQgcz0wLGk9MDtjb25zdCBjPSIgPiAiLHU9Yy5sZW5ndGg7bGV0IGE7Y29uc3QgZj1BcnJheS5pc0FycmF5KG4pP246bi5rZXlBdHRycyxoPSFBcnJheS5pc0FycmF5KG4pJiZuLm1heFN0cmluZ0xlbmd0aHx8dztmb3IoO2UmJnMrKzxyJiYoYT1TKGUsZiksISgiaHRtbCI9PT1hfHxzPjEmJmkrby5sZW5ndGgqdSthLmxlbmd0aD49aCkpOylvLnB1c2goYSksaSs9YS5sZW5ndGgsZT1lLnBhcmVudE5vZGU7cmV0dXJuIG8ucmV2ZXJzZSgpLmpvaW4oYyl9Y2F0Y2godCl7cmV0dXJuIjx1bmtub3duPiJ9fSh0KTpPYmplY3QucHJvdG90eXBlLnRvU3RyaW5nLmNhbGwodCl9Y2F0Y2godCl7cmV0dXJuIjx1bmtub3duPiJ9dmFyIG59ZnVuY3Rpb24gaih0KXtpZigib2JqZWN0Ij09dHlwZW9mIHQmJm51bGwhPT10KXtjb25zdCBuPXt9O2Zvcihjb25zdCBlIGluIHQpT2JqZWN0LnByb3RvdHlwZS5oYXNPd25Qcm9wZXJ0eS5jYWxsKHQsZSkmJihuW2VdPXRbZV0pO3JldHVybiBufXJldHVybnt9fWZ1bmN0aW9uIE8odCl7cmV0dXJuIEEodCxuZXcgTWFwKX1mdW5jdGlvbiBBKHQsbil7aWYoZnVuY3Rpb24odCl7aWYoIWQodCkpcmV0dXJuITE7dHJ5e2NvbnN0IG49T2JqZWN0LmdldFByb3RvdHlwZU9mKHQpLmNvbnN0cnVjdG9yLm5hbWU7cmV0dXJuIW58fCJPYmplY3QiPT09bn1jYXRjaCh0KXtyZXR1cm4hMH19KHQpKXtjb25zdCBlPW4uZ2V0KHQpO2lmKHZvaWQgMCE9PWUpcmV0dXJuIGU7Y29uc3Qgcj17fTtuLnNldCh0LHIpO2Zvcihjb25zdCBlIG9mIE9iamVjdC5nZXRPd25Qcm9wZXJ0eU5hbWVzKHQpKXZvaWQgMCE9PXRbZV0mJihyW2VdPUEodFtlXSxuKSk7cmV0dXJuIHJ9aWYoQXJyYXkuaXNBcnJheSh0KSl7Y29uc3QgZT1uLmdldCh0KTtpZih2b2lkIDAhPT1lKXJldHVybiBlO2NvbnN0IHI9W107cmV0dXJuIG4uc2V0KHQsciksdC5mb3JFYWNoKCh0PT57ci5wdXNoKEEodCxuKSl9KSkscn1yZXR1cm4gdH1jb25zdCBJPTUwLFA9Ij8iLFU9L2NhcHR1cmVNZXNzYWdlfGNhcHR1cmVFeGNlcHRpb24vO2Z1bmN0aW9uIE0odCl7cmV0dXJuIHRbdC5sZW5ndGgtMV18fHt9fWNvbnN0IEw9Ijxhbm9ueW1vdXM+Ijtjb25zdCBCPTFlMztmdW5jdGlvbiBHKCl7cmV0dXJuIERhdGUubm93KCkvQn1jb25zdCBKPWZ1bmN0aW9uKCl7Y29uc3R7cGVyZm9ybWFuY2U6dH09YjtpZighdHx8IXQubm93KXJldHVybiBHO2NvbnN0IG49RGF0ZS5ub3coKS10Lm5vdygpLGU9bnVsbD09dC50aW1lT3JpZ2luP246dC50aW1lT3JpZ2luO3JldHVybigpPT4oZSt0Lm5vdygpKS9CfSgpO2Z1bmN0aW9uIFkoKXtjb25zdCB0PWIsbj10LmNyeXB0b3x8dC5tc0NyeXB0bztsZXQgZT0oKT0+MTYqTWF0aC5yYW5kb20oKTt0cnl7aWYobiYmbi5yYW5kb21VVUlEKXJldHVybiBuLnJhbmRvbVVVSUQoKS5yZXBsYWNlKC8tL2csIiIpO24mJm4uZ2V0UmFuZG9tVmFsdWVzJiYoZT0oKT0+e2NvbnN0IHQ9bmV3IFVpbnQ4QXJyYXkoMSk7cmV0dXJuIG4uZ2V0UmFuZG9tVmFsdWVzKHQpLHRbMF19KX1jYXRjaCh0KXt9cmV0dXJuKFsxZTddKzFlMys0ZTMrOGUzKzFlMTEpLnJlcGxhY2UoL1swMThdL2csKHQ9Pih0XigxNSZlKCkpPj50LzQpLnRvU3RyaW5nKDE2KSkpfWZ1bmN0aW9uIHoodCxuPTEwMCxlPTEvMCl7dHJ5e3JldHVybiBIKCIiLHQsbixlKX1jYXRjaCh0KXtyZXR1cm57RVJST1I6YCoqbm9uLXNlcmlhbGl6YWJsZSoqICgke3R9KWB9fX1mdW5jdGlvbiBIKHQsbixlPTEvMCxyPTEvMCxvPWZ1bmN0aW9uKCl7Y29uc3QgdD0iZnVuY3Rpb24iPT10eXBlb2YgV2Vha1NldCxuPXQ/bmV3IFdlYWtTZXQ6W107cmV0dXJuW2Z1bmN0aW9uKGUpe2lmKHQpcmV0dXJuISFuLmhhcyhlKXx8KG4uYWRkKGUpLCExKTtmb3IobGV0IHQ9MDt0PG4ubGVuZ3RoO3QrKylpZihuW3RdPT09ZSlyZXR1cm4hMDtyZXR1cm4gbi5wdXNoKGUpLCExfSxmdW5jdGlvbihlKXtpZih0KW4uZGVsZXRlKGUpO2Vsc2UgZm9yKGxldCB0PTA7dDxuLmxlbmd0aDt0KyspaWYoblt0XT09PWUpe24uc3BsaWNlKHQsMSk7YnJlYWt9fV19KCkpe2NvbnN0W3MsaV09bztpZihudWxsPT1ufHxbImJvb2xlYW4iLCJzdHJpbmciXS5pbmNsdWRlcyh0eXBlb2Ygbil8fCJudW1iZXIiPT10eXBlb2YgbiYmTnVtYmVyLmlzRmluaXRlKG4pKXJldHVybiBuO2NvbnN0IGM9ZnVuY3Rpb24odCxuKXt0cnl7aWYoImRvbWFpbiI9PT10JiZuJiYib2JqZWN0Ij09dHlwZW9mIG4mJm4udClyZXR1cm4iW0RvbWFpbl0iO2lmKCJkb21haW5FbWl0dGVyIj09PXQpcmV0dXJuIltEb21haW5FbWl0dGVyXSI7aWYoInVuZGVmaW5lZCIhPXR5cGVvZiBnbG9iYWwmJm49PT1nbG9iYWwpcmV0dXJuIltHbG9iYWxdIjtpZigidW5kZWZpbmVkIiE9dHlwZW9mIHdpbmRvdyYmbj09PXdpbmRvdylyZXR1cm4iW1dpbmRvd10iO2lmKCJ1bmRlZmluZWQiIT10eXBlb2YgZG9jdW1lbnQmJm49PT1kb2N1bWVudClyZXR1cm4iW0RvY3VtZW50XSI7aWYoIm9iamVjdCI9PXR5cGVvZihlPW4pJiZudWxsIT09ZSYmKGUuX19pc1Z1ZXx8ZS5vKSlyZXR1cm4iW1Z1ZVZpZXdNb2RlbF0iO2lmKGZ1bmN0aW9uKHQpe3JldHVybiBkKHQpJiYibmF0aXZlRXZlbnQiaW4gdCYmInByZXZlbnREZWZhdWx0ImluIHQmJiJzdG9wUHJvcGFnYXRpb24iaW4gdH0obikpcmV0dXJuIltTeW50aGV0aWNFdmVudF0iO2lmKCJudW1iZXIiPT10eXBlb2YgbiYmIU51bWJlci5pc0Zpbml0ZShuKSlyZXR1cm5gWyR7bn1dYDtpZigiZnVuY3Rpb24iPT10eXBlb2YgbilyZXR1cm5gW0Z1bmN0aW9uOiAke2Z1bmN0aW9uKHQpe3RyeXtyZXR1cm4gdCYmImZ1bmN0aW9uIj09dHlwZW9mIHQmJnQubmFtZXx8TH1jYXRjaCh0KXtyZXR1cm4gTH19KG4pfV1gO2lmKCJzeW1ib2wiPT10eXBlb2YgbilyZXR1cm5gWyR7U3RyaW5nKG4pfV1gO2lmKCJiaWdpbnQiPT10eXBlb2YgbilyZXR1cm5gW0JpZ0ludDogJHtTdHJpbmcobil9XWA7Y29uc3Qgcj1mdW5jdGlvbih0KXtjb25zdCBuPU9iamVjdC5nZXRQcm90b3R5cGVPZih0KTtyZXR1cm4gbj9uLmNvbnN0cnVjdG9yLm5hbWU6Im51bGwgcHJvdG90eXBlIn0obik7cmV0dXJuL15IVE1MKFx3KilFbGVtZW50JC8udGVzdChyKT9gW0hUTUxFbGVtZW50OiAke3J9XWA6YFtvYmplY3QgJHtyfV1gfWNhdGNoKHQpe3JldHVybmAqKm5vbi1zZXJpYWxpemFibGUqKiAoJHt0fSlgfXZhciBlfSh0LG4pO2lmKCFjLnN0YXJ0c1dpdGgoIltvYmplY3QgIikpcmV0dXJuIGM7aWYobi5fX3NlbnRyeV9za2lwX25vcm1hbGl6YXRpb25fXylyZXR1cm4gbjtjb25zdCB1PSJudW1iZXIiPT10eXBlb2Ygbi5fX3NlbnRyeV9vdmVycmlkZV9ub3JtYWxpemF0aW9uX2RlcHRoX18/bi5fX3NlbnRyeV9vdmVycmlkZV9ub3JtYWxpemF0aW9uX2RlcHRoX186ZTtpZigwPT09dSlyZXR1cm4gYy5yZXBsYWNlKCJvYmplY3QgIiwiIik7aWYocyhuKSlyZXR1cm4iW0NpcmN1bGFyIH5dIjtjb25zdCBhPW47aWYoYSYmImZ1bmN0aW9uIj09dHlwZW9mIGEudG9KU09OKXRyeXtyZXR1cm4gSCgiIixhLnRvSlNPTigpLHUtMSxyLG8pfWNhdGNoKHQpe31jb25zdCBmPUFycmF5LmlzQXJyYXkobik/W106e307bGV0IGg9MDtjb25zdCBwPVIobik7Zm9yKGNvbnN0IHQgaW4gcCl7aWYoIU9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChwLHQpKWNvbnRpbnVlO2lmKGg+PXIpe2ZbdF09IltNYXhQcm9wZXJ0aWVzIH5dIjticmVha31jb25zdCBuPXBbdF07Zlt0XT1IKHQsbix1LTEscixvKSxoKyt9cmV0dXJuIGkobiksZn1mdW5jdGlvbiBXKHQsbil7Y29uc3QgZT1uLnJlcGxhY2UoL1xcL2csIi8iKS5yZXBsYWNlKC9bfFxce30oKVtcXV4kKyo/Ll0vZywiXFwkJiIpO2xldCByPXQ7dHJ5e3I9ZGVjb2RlVVJJKHQpfWNhdGNoKHQpe31yZXR1cm4gci5yZXBsYWNlKC9cXC9nLCIvIikucmVwbGFjZSgvd2VicGFjazpcLz8vZywiIikucmVwbGFjZShuZXcgUmVnRXhwKGAoZmlsZTovLyk/Lyoke2V9LypgLCJpZyIpLCJhcHA6Ly8vIil9KCgpPT57Y29uc3R7cGVyZm9ybWFuY2U6dH09YjtpZighdHx8IXQubm93KXJldHVybjtjb25zdCBuPTM2ZTUsZT10Lm5vdygpLHI9RGF0ZS5ub3coKSxvPXQudGltZU9yaWdpbj9NYXRoLmFicyh0LnRpbWVPcmlnaW4rZS1yKTpuLHM9bzxuLGk9dC50aW1pbmcmJnQudGltaW5nLm5hdmlnYXRpb25TdGFydCxjPSJudW1iZXIiPT10eXBlb2YgaT9NYXRoLmFicyhpK2Utcik6bjsoc3x8YzxuKSYmKG88PWMmJnQudGltZU9yaWdpbil9KSgpO2NvbnN0IHE9L14oXFMrOlxcfFwvPykoW1xzXFNdKj8pKCg/OlwuezEsMn18W14vXFxdKz98KShcLlteLi9cXF0qfCkpKD86Wy9cXF0qKSQvO2Z1bmN0aW9uIEYodCl7Y29uc3Qgbj1mdW5jdGlvbih0KXtjb25zdCBuPXQubGVuZ3RoPjEwMjQ/YDx0cnVuY2F0ZWQ+JHt0LnNsaWNlKC0xMDI0KX1gOnQsZT1xLmV4ZWMobik7cmV0dXJuIGU/ZS5zbGljZSgxKTpbXX0odCksZT1uWzBdfHwiIjtsZXQgcj1uWzFdO3JldHVybiBlfHxyPyhyJiYocj1yLnNsaWNlKDAsci5sZW5ndGgtMSkpLGUrcik6Ii4ifXZhciBLO2Z1bmN0aW9uIFYodCl7cmV0dXJuIG5ldyBaKChuPT57bih0KX0pKX0hZnVuY3Rpb24odCl7dFt0LlBFTkRJTkc9MF09IlBFTkRJTkciO3RbdC5SRVNPTFZFRD0xXT0iUkVTT0xWRUQiO3RbdC5SRUpFQ1RFRD0yXT0iUkVKRUNURUQifShLfHwoSz17fSkpO2NsYXNzIFp7Y29uc3RydWN0b3IodCl7Wi5wcm90b3R5cGUuX19pbml0LmNhbGwodGhpcyksWi5wcm90b3R5cGUuX19pbml0Mi5jYWxsKHRoaXMpLFoucHJvdG90eXBlLl9faW5pdDMuY2FsbCh0aGlzKSxaLnByb3RvdHlwZS5fX2luaXQ0LmNhbGwodGhpcyksdGhpcy5pPUsuUEVORElORyx0aGlzLnU9W107dHJ5e3QodGhpcy5oLHRoaXMucCl9Y2F0Y2godCl7dGhpcy5wKHQpfX10aGVuKHQsbil7cmV0dXJuIG5ldyBaKCgoZSxyKT0+e3RoaXMudS5wdXNoKFshMSxuPT57aWYodCl0cnl7ZSh0KG4pKX1jYXRjaCh0KXtyKHQpfWVsc2UgZShuKX0sdD0+e2lmKG4pdHJ5e2Uobih0KSl9Y2F0Y2godCl7cih0KX1lbHNlIHIodCl9XSksdGhpcy5sKCl9KSl9Y2F0Y2godCl7cmV0dXJuIHRoaXMudGhlbigodD0+dCksdCl9ZmluYWxseSh0KXtyZXR1cm4gbmV3IFooKChuLGUpPT57bGV0IHIsbztyZXR1cm4gdGhpcy50aGVuKChuPT57bz0hMSxyPW4sdCYmdCgpfSksKG49PntvPSEwLHI9bix0JiZ0KCl9KSkudGhlbigoKCk9PntvP2Uocik6bihyKX0pKX0pKX1fX2luaXQoKXt0aGlzLmg9dD0+e3RoaXMubShLLlJFU09MVkVELHQpfX1fX2luaXQyKCl7dGhpcy5wPXQ9Pnt0aGlzLm0oSy5SRUpFQ1RFRCx0KX19X19pbml0Mygpe3RoaXMubT0odCxuKT0+e3RoaXMuaT09PUsuUEVORElORyYmKG0obik/bi50aGVuKHRoaXMuaCx0aGlzLnApOih0aGlzLmk9dCx0aGlzLl89bix0aGlzLmwoKSkpfX1fX2luaXQ0KCl7dGhpcy5sPSgpPT57aWYodGhpcy5pPT09Sy5QRU5ESU5HKXJldHVybjtjb25zdCB0PXRoaXMudS5zbGljZSgpO3RoaXMudT1bXSx0LmZvckVhY2goKHQ9Pnt0WzBdfHwodGhpcy5pPT09Sy5SRVNPTFZFRCYmdFsxXSh0aGlzLl8pLHRoaXMuaT09PUsuUkVKRUNURUQmJnRbMl0odGhpcy5fKSx0WzBdPSEwKX0pKX19fWZ1bmN0aW9uIFEodCl7Y29uc3Qgbj1bXTtmdW5jdGlvbiBlKHQpe3JldHVybiBuLnNwbGljZShuLmluZGV4T2YodCksMSlbMF18fFByb21pc2UucmVzb2x2ZSh2b2lkIDApfXJldHVybnskOm4sYWRkOmZ1bmN0aW9uKHIpe2lmKCEodm9pZCAwPT09dHx8bi5sZW5ndGg8dCkpcmV0dXJuIG89bmV3IFQoIk5vdCBhZGRpbmcgUHJvbWlzZSBiZWNhdXNlIGJ1ZmZlciBsaW1pdCB3YXMgcmVhY2hlZC4iKSxuZXcgWigoKHQsbik9PntuKG8pfSkpO3ZhciBvO2NvbnN0IHM9cigpO3JldHVybi0xPT09bi5pbmRleE9mKHMpJiZuLnB1c2gocykscy50aGVuKCgoKT0+ZShzKSkpLnRoZW4obnVsbCwoKCk9PmUocykudGhlbihudWxsLCgoKT0+e30pKSkpLHN9LGRyYWluOmZ1bmN0aW9uKHQpe3JldHVybiBuZXcgWigoKGUscik9PntsZXQgbz1uLmxlbmd0aDtpZighbylyZXR1cm4gZSghMCk7Y29uc3Qgcz1zZXRUaW1lb3V0KCgoKT0+e3QmJnQ+MCYmZSghMSl9KSx0KTtuLmZvckVhY2goKHQ9PntWKHQpLnRoZW4oKCgpPT57LS1vfHwoY2xlYXJUaW1lb3V0KHMpLGUoITApKX0pLHIpfSkpfSkpfX19ZnVuY3Rpb24gWCh0LG49ITEpe3JldHVybiEobnx8dCYmIXQuc3RhcnRzV2l0aCgiLyIpJiYhdC5tYXRjaCgvXltBLVpdOi8pJiYhdC5zdGFydHNXaXRoKCIuIikmJiF0Lm1hdGNoKC9eW2EtekEtWl0oW2EtekEtWjAtOS5cLStdKSo6XC9cLy8pKSYmdm9pZCAwIT09dCYmIXQuaW5jbHVkZXMoIm5vZGVfbW9kdWxlcy8iKX1jb25zdCB0dD0ic2VudHJ5LSIsbnQ9L15zZW50cnktLztmdW5jdGlvbiBldCh0KXtjb25zdCBuPWZ1bmN0aW9uKHQpe2lmKCF0fHwhbCh0KSYmIUFycmF5LmlzQXJyYXkodCkpcmV0dXJuO2lmKEFycmF5LmlzQXJyYXkodCkpcmV0dXJuIHQucmVkdWNlKCgodCxuKT0+e2NvbnN0IGU9cnQobik7cmV0dXJuIE9iamVjdC5lbnRyaWVzKGUpLmZvckVhY2goKChbbixlXSk9Pnt0W25dPWV9KSksdH0pLHt9KTtyZXR1cm4gcnQodCl9KHQpO2lmKCFuKXJldHVybjtjb25zdCBlPU9iamVjdC5lbnRyaWVzKG4pLnJlZHVjZSgoKHQsW24sZV0pPT57aWYobi5tYXRjaChudCkpe3Rbbi5zbGljZSh0dC5sZW5ndGgpXT1lfXJldHVybiB0fSkse30pO3JldHVybiBPYmplY3Qua2V5cyhlKS5sZW5ndGg+MD9lOnZvaWQgMH1mdW5jdGlvbiBydCh0KXtyZXR1cm4gdC5zcGxpdCgiLCIpLm1hcCgodD0+dC5zcGxpdCgiPSIpLm1hcCgodD0+ZGVjb2RlVVJJQ29tcG9uZW50KHQudHJpbSgpKSkpKSkucmVkdWNlKCgodCxbbixlXSk9PihuJiZlJiYodFtuXT1lKSx0KSkse30pfWZ1bmN0aW9uIG90KHQsbj1bXSl7cmV0dXJuW3Qsbl19ZnVuY3Rpb24gc3QodCxuKXtjb25zdCBlPXRbMV07Zm9yKGNvbnN0IHQgb2YgZSl7aWYobih0LHRbMF0udHlwZSkpcmV0dXJuITB9cmV0dXJuITF9ZnVuY3Rpb24gaXQodCl7cmV0dXJuIGIuX19TRU5UUllfXyYmYi5fX1NFTlRSWV9fLmVuY29kZVBvbHlmaWxsP2IuX19TRU5UUllfXy5lbmNvZGVQb2x5ZmlsbCh0KToobmV3IFRleHRFbmNvZGVyKS5lbmNvZGUodCl9ZnVuY3Rpb24gY3QodCl7Y29uc3RbbixlXT10O2xldCByPUpTT04uc3RyaW5naWZ5KG4pO2Z1bmN0aW9uIG8odCl7InN0cmluZyI9PXR5cGVvZiByP3I9InN0cmluZyI9PXR5cGVvZiB0P3IrdDpbaXQociksdF06ci5wdXNoKCJzdHJpbmciPT10eXBlb2YgdD9pdCh0KTp0KX1mb3IoY29uc3QgdCBvZiBlKXtjb25zdFtuLGVdPXQ7aWYobyhgXG4ke0pTT04uc3RyaW5naWZ5KG4pfVxuYCksInN0cmluZyI9PXR5cGVvZiBlfHxlIGluc3RhbmNlb2YgVWludDhBcnJheSlvKGUpO2Vsc2V7bGV0IHQ7dHJ5e3Q9SlNPTi5zdHJpbmdpZnkoZSl9Y2F0Y2gobil7dD1KU09OLnN0cmluZ2lmeSh6KGUpKX1vKHQpfX1yZXR1cm4ic3RyaW5nIj09dHlwZW9mIHI/cjpmdW5jdGlvbih0KXtjb25zdCBuPXQucmVkdWNlKCgodCxuKT0+dCtuLmxlbmd0aCksMCksZT1uZXcgVWludDhBcnJheShuKTtsZXQgcj0wO2Zvcihjb25zdCBuIG9mIHQpZS5zZXQobixyKSxyKz1uLmxlbmd0aDtyZXR1cm4gZX0ocil9Y29uc3QgdXQ9e3Nlc3Npb246InNlc3Npb24iLHNlc3Npb25zOiJzZXNzaW9uIixhdHRhY2htZW50OiJhdHRhY2htZW50Iix0cmFuc2FjdGlvbjoidHJhbnNhY3Rpb24iLGV2ZW50OiJlcnJvciIsY2xpZW50X3JlcG9ydDoiaW50ZXJuYWwiLHVzZXJfcmVwb3J0OiJkZWZhdWx0Iixwcm9maWxlOiJwcm9maWxlIixwcm9maWxlX2NodW5rOiJwcm9maWxlIixyZXBsYXlfZXZlbnQ6InJlcGxheSIscmVwbGF5X3JlY29yZGluZzoicmVwbGF5IixjaGVja19pbjoibW9uaXRvciIsZmVlZGJhY2s6ImZlZWRiYWNrIixzcGFuOiJzcGFuIixzdGF0c2Q6Im1ldHJpY19idWNrZXQifTtmdW5jdGlvbiBhdCh0KXtyZXR1cm4gdXRbdF19ZnVuY3Rpb24gZnQodCl7aWYoIXR8fCF0LnNkaylyZXR1cm47Y29uc3R7bmFtZTpuLHZlcnNpb246ZX09dC5zZGs7cmV0dXJue25hbWU6bix2ZXJzaW9uOmV9fWNvbnN0IGh0PTZlNDtmdW5jdGlvbiBwdCh0LHtzdGF0dXNDb2RlOm4saGVhZGVyczplfSxyPURhdGUubm93KCkpe2NvbnN0IG89ey4uLnR9LHM9ZSYmZVsieC1zZW50cnktcmF0ZS1saW1pdHMiXSxpPWUmJmVbInJldHJ5LWFmdGVyIl07aWYocylmb3IoY29uc3QgdCBvZiBzLnRyaW0oKS5zcGxpdCgiLCIpKXtjb25zdFtuLGUsLCxzXT10LnNwbGl0KCI6Iiw1KSxpPXBhcnNlSW50KG4sMTApLGM9MWUzKihpc05hTihpKT82MDppKTtpZihlKWZvcihjb25zdCB0IG9mIGUuc3BsaXQoIjsiKSkibWV0cmljX2J1Y2tldCI9PT10JiZzJiYhcy5zcGxpdCgiOyIpLmluY2x1ZGVzKCJjdXN0b20iKXx8KG9bdF09citjKTtlbHNlIG8uYWxsPXIrY31lbHNlIGk/by5hbGw9citmdW5jdGlvbih0LG49RGF0ZS5ub3coKSl7Y29uc3QgZT1wYXJzZUludChgJHt0fWAsMTApO2lmKCFpc05hTihlKSlyZXR1cm4gMWUzKmU7Y29uc3Qgcj1EYXRlLnBhcnNlKGAke3R9YCk7cmV0dXJuIGlzTmFOKHIpP2h0OnItbn0oaSxyKTo0Mjk9PT1uJiYoby5hbGw9cis2ZTQpO3JldHVybiBvfWZ1bmN0aW9uIGx0KCl7cmV0dXJue3RyYWNlSWQ6WSgpLHNwYW5JZDpZKCkuc3Vic3RyaW5nKDE2KX19Y29uc3QgZHQ9InVuZGVmaW5lZCI9PXR5cGVvZiBfX1NFTlRSWV9ERUJVR19ffHxfX1NFTlRSWV9ERUJVR19fO2Z1bmN0aW9uIG10KCl7cmV0dXJuIHl0KGIpLGJ9ZnVuY3Rpb24geXQodCl7Y29uc3Qgbj10Ll9fU0VOVFJZX189dC5fX1NFTlRSWV9ffHx7fTtyZXR1cm4gbi52ZXJzaW9uPW4udmVyc2lvbnx8ZyxuW2ddPW5bZ118fHt9fWZ1bmN0aW9uIGd0KHQpe2NvbnN0IG49SigpLGU9e3NpZDpZKCksaW5pdDohMCx0aW1lc3RhbXA6bixzdGFydGVkOm4sZHVyYXRpb246MCxzdGF0dXM6Im9rIixlcnJvcnM6MCxpZ25vcmVEdXJhdGlvbjohMSx0b0pTT046KCk9PmZ1bmN0aW9uKHQpe3JldHVybiBPKHtzaWQ6YCR7dC5zaWR9YCxpbml0OnQuaW5pdCxzdGFydGVkOm5ldyBEYXRlKDFlMyp0LnN0YXJ0ZWQpLnRvSVNPU3RyaW5nKCksdGltZXN0YW1wOm5ldyBEYXRlKDFlMyp0LnRpbWVzdGFtcCkudG9JU09TdHJpbmcoKSxzdGF0dXM6dC5zdGF0dXMsZXJyb3JzOnQuZXJyb3JzLGRpZDoibnVtYmVyIj09dHlwZW9mIHQuZGlkfHwic3RyaW5nIj09dHlwZW9mIHQuZGlkP2Ake3QuZGlkfWA6dm9pZCAwLGR1cmF0aW9uOnQuZHVyYXRpb24sYWJub3JtYWxfbWVjaGFuaXNtOnQuYWJub3JtYWxfbWVjaGFuaXNtLGF0dHJzOntyZWxlYXNlOnQucmVsZWFzZSxlbnZpcm9ubWVudDp0LmVudmlyb25tZW50LGlwX2FkZHJlc3M6dC5pcEFkZHJlc3MsdXNlcl9hZ2VudDp0LnVzZXJBZ2VudH19KX0oZSl9O3JldHVybiB0JiZidChlLHQpLGV9ZnVuY3Rpb24gYnQodCxuPXt9KXtpZihuLnVzZXImJighdC5pcEFkZHJlc3MmJm4udXNlci5pcF9hZGRyZXNzJiYodC5pcEFkZHJlc3M9bi51c2VyLmlwX2FkZHJlc3MpLHQuZGlkfHxuLmRpZHx8KHQuZGlkPW4udXNlci5pZHx8bi51c2VyLmVtYWlsfHxuLnVzZXIudXNlcm5hbWUpKSx0LnRpbWVzdGFtcD1uLnRpbWVzdGFtcHx8SigpLG4uYWJub3JtYWxfbWVjaGFuaXNtJiYodC5hYm5vcm1hbF9tZWNoYW5pc209bi5hYm5vcm1hbF9tZWNoYW5pc20pLG4uaWdub3JlRHVyYXRpb24mJih0Lmlnbm9yZUR1cmF0aW9uPW4uaWdub3JlRHVyYXRpb24pLG4uc2lkJiYodC5zaWQ9MzI9PT1uLnNpZC5sZW5ndGg/bi5zaWQ6WSgpKSx2b2lkIDAhPT1uLmluaXQmJih0LmluaXQ9bi5pbml0KSwhdC5kaWQmJm4uZGlkJiYodC5kaWQ9YCR7bi5kaWR9YCksIm51bWJlciI9PXR5cGVvZiBuLnN0YXJ0ZWQmJih0LnN0YXJ0ZWQ9bi5zdGFydGVkKSx0Lmlnbm9yZUR1cmF0aW9uKXQuZHVyYXRpb249dm9pZCAwO2Vsc2UgaWYoIm51bWJlciI9PXR5cGVvZiBuLmR1cmF0aW9uKXQuZHVyYXRpb249bi5kdXJhdGlvbjtlbHNle2NvbnN0IG49dC50aW1lc3RhbXAtdC5zdGFydGVkO3QuZHVyYXRpb249bj49MD9uOjB9bi5yZWxlYXNlJiYodC5yZWxlYXNlPW4ucmVsZWFzZSksbi5lbnZpcm9ubWVudCYmKHQuZW52aXJvbm1lbnQ9bi5lbnZpcm9ubWVudCksIXQuaXBBZGRyZXNzJiZuLmlwQWRkcmVzcyYmKHQuaXBBZGRyZXNzPW4uaXBBZGRyZXNzKSwhdC51c2VyQWdlbnQmJm4udXNlckFnZW50JiYodC51c2VyQWdlbnQ9bi51c2VyQWdlbnQpLCJudW1iZXIiPT10eXBlb2Ygbi5lcnJvcnMmJih0LmVycm9ycz1uLmVycm9ycyksbi5zdGF0dXMmJih0LnN0YXR1cz1uLnN0YXR1cyl9Y29uc3QgX3Q9Il9zZW50cnlTcGFuIjtmdW5jdGlvbiB2dCh0LG4pe24/ZnVuY3Rpb24odCxuLGUpe3RyeXtPYmplY3QuZGVmaW5lUHJvcGVydHkodCxuLHt2YWx1ZTplLHdyaXRhYmxlOiEwLGNvbmZpZ3VyYWJsZTohMH0pfWNhdGNoKGUpeyQmJmsubG9nKGBGYWlsZWQgdG8gYWRkIG5vbi1lbnVtZXJhYmxlIHByb3BlcnR5ICIke259IiB0byBvYmplY3RgLHQpfX0odCxfdCxuKTpkZWxldGUgdFtfdF19ZnVuY3Rpb24gd3QodCl7cmV0dXJuIHRbX3RdfWNsYXNzIFN0e2NvbnN0cnVjdG9yKCl7dGhpcy52PSExLHRoaXMuUz1bXSx0aGlzLk49W10sdGhpcy5rPVtdLHRoaXMuQz1bXSx0aGlzLlQ9e30sdGhpcy5SPXt9LHRoaXMuRD17fSx0aGlzLmo9e30sdGhpcy5PPXt9LHRoaXMuQT1sdCgpfWNsb25lKCl7Y29uc3QgdD1uZXcgU3Q7cmV0dXJuIHQuaz1bLi4udGhpcy5rXSx0LlI9ey4uLnRoaXMuUn0sdC5EPXsuLi50aGlzLkR9LHQuaj17Li4udGhpcy5qfSx0LlQ9dGhpcy5ULHQuST10aGlzLkksdC5QPXRoaXMuUCx0LlU9dGhpcy5VLHQuTT10aGlzLk0sdC5OPVsuLi50aGlzLk5dLHQuTD10aGlzLkwsdC5DPVsuLi50aGlzLkNdLHQuTz17Li4udGhpcy5PfSx0LkE9ey4uLnRoaXMuQX0sdC5CPXRoaXMuQix0Lkc9dGhpcy5HLHZ0KHQsd3QodGhpcykpLHR9c2V0Q2xpZW50KHQpe3RoaXMuQj10fXNldExhc3RFdmVudElkKHQpe3RoaXMuRz10fWdldENsaWVudCgpe3JldHVybiB0aGlzLkJ9bGFzdEV2ZW50SWQoKXtyZXR1cm4gdGhpcy5HfWFkZFNjb3BlTGlzdGVuZXIodCl7dGhpcy5TLnB1c2godCl9YWRkRXZlbnRQcm9jZXNzb3IodCl7cmV0dXJuIHRoaXMuTi5wdXNoKHQpLHRoaXN9c2V0VXNlcih0KXtyZXR1cm4gdGhpcy5UPXR8fHtlbWFpbDp2b2lkIDAsaWQ6dm9pZCAwLGlwX2FkZHJlc3M6dm9pZCAwLHVzZXJuYW1lOnZvaWQgMH0sdGhpcy5QJiZidCh0aGlzLlAse3VzZXI6dH0pLHRoaXMuSigpLHRoaXN9Z2V0VXNlcigpe3JldHVybiB0aGlzLlR9Z2V0UmVxdWVzdFNlc3Npb24oKXtyZXR1cm4gdGhpcy5MfXNldFJlcXVlc3RTZXNzaW9uKHQpe3JldHVybiB0aGlzLkw9dCx0aGlzfXNldFRhZ3ModCl7cmV0dXJuIHRoaXMuUj17Li4udGhpcy5SLC4uLnR9LHRoaXMuSigpLHRoaXN9c2V0VGFnKHQsbil7cmV0dXJuIHRoaXMuUj17Li4udGhpcy5SLFt0XTpufSx0aGlzLkooKSx0aGlzfXNldEV4dHJhcyh0KXtyZXR1cm4gdGhpcy5EPXsuLi50aGlzLkQsLi4udH0sdGhpcy5KKCksdGhpc31zZXRFeHRyYSh0LG4pe3JldHVybiB0aGlzLkQ9ey4uLnRoaXMuRCxbdF06bn0sdGhpcy5KKCksdGhpc31zZXRGaW5nZXJwcmludCh0KXtyZXR1cm4gdGhpcy5NPXQsdGhpcy5KKCksdGhpc31zZXRMZXZlbCh0KXtyZXR1cm4gdGhpcy5JPXQsdGhpcy5KKCksdGhpc31zZXRUcmFuc2FjdGlvbk5hbWUodCl7cmV0dXJuIHRoaXMuVT10LHRoaXMuSigpLHRoaXN9c2V0Q29udGV4dCh0LG4pe3JldHVybiBudWxsPT09bj9kZWxldGUgdGhpcy5qW3RdOnRoaXMualt0XT1uLHRoaXMuSigpLHRoaXN9c2V0U2Vzc2lvbih0KXtyZXR1cm4gdD90aGlzLlA9dDpkZWxldGUgdGhpcy5QLHRoaXMuSigpLHRoaXN9Z2V0U2Vzc2lvbigpe3JldHVybiB0aGlzLlB9dXBkYXRlKHQpe2lmKCF0KXJldHVybiB0aGlzO2NvbnN0IG49ImZ1bmN0aW9uIj09dHlwZW9mIHQ/dCh0aGlzKTp0LFtlLHJdPW4gaW5zdGFuY2VvZiAkdD9bbi5nZXRTY29wZURhdGEoKSxuLmdldFJlcXVlc3RTZXNzaW9uKCldOmQobik/W3QsdC5yZXF1ZXN0U2Vzc2lvbl06W10se3RhZ3M6byxleHRyYTpzLHVzZXI6aSxjb250ZXh0czpjLGxldmVsOnUsZmluZ2VycHJpbnQ6YT1bXSxwcm9wYWdhdGlvbkNvbnRleHQ6Zn09ZXx8e307cmV0dXJuIHRoaXMuUj17Li4udGhpcy5SLC4uLm99LHRoaXMuRD17Li4udGhpcy5ELC4uLnN9LHRoaXMuaj17Li4udGhpcy5qLC4uLmN9LGkmJk9iamVjdC5rZXlzKGkpLmxlbmd0aCYmKHRoaXMuVD1pKSx1JiYodGhpcy5JPXUpLGEubGVuZ3RoJiYodGhpcy5NPWEpLGYmJih0aGlzLkE9ZiksciYmKHRoaXMuTD1yKSx0aGlzfWNsZWFyKCl7cmV0dXJuIHRoaXMuaz1bXSx0aGlzLlI9e30sdGhpcy5EPXt9LHRoaXMuVD17fSx0aGlzLmo9e30sdGhpcy5JPXZvaWQgMCx0aGlzLlU9dm9pZCAwLHRoaXMuTT12b2lkIDAsdGhpcy5MPXZvaWQgMCx0aGlzLlA9dm9pZCAwLHZ0KHRoaXMsdm9pZCAwKSx0aGlzLkM9W10sdGhpcy5BPWx0KCksdGhpcy5KKCksdGhpc31hZGRCcmVhZGNydW1iKHQsbil7Y29uc3QgZT0ibnVtYmVyIj09dHlwZW9mIG4/bjoxMDA7aWYoZTw9MClyZXR1cm4gdGhpcztjb25zdCByPXt0aW1lc3RhbXA6RygpLC4uLnR9LG89dGhpcy5rO3JldHVybiBvLnB1c2gociksdGhpcy5rPW8ubGVuZ3RoPmU/by5zbGljZSgtZSk6byx0aGlzLkooKSx0aGlzfWdldExhc3RCcmVhZGNydW1iKCl7cmV0dXJuIHRoaXMua1t0aGlzLmsubGVuZ3RoLTFdfWNsZWFyQnJlYWRjcnVtYnMoKXtyZXR1cm4gdGhpcy5rPVtdLHRoaXMuSigpLHRoaXN9YWRkQXR0YWNobWVudCh0KXtyZXR1cm4gdGhpcy5DLnB1c2godCksdGhpc31jbGVhckF0dGFjaG1lbnRzKCl7cmV0dXJuIHRoaXMuQz1bXSx0aGlzfWdldFNjb3BlRGF0YSgpe3JldHVybnticmVhZGNydW1iczp0aGlzLmssYXR0YWNobWVudHM6dGhpcy5DLGNvbnRleHRzOnRoaXMuaix0YWdzOnRoaXMuUixleHRyYTp0aGlzLkQsdXNlcjp0aGlzLlQsbGV2ZWw6dGhpcy5JLGZpbmdlcnByaW50OnRoaXMuTXx8W10sZXZlbnRQcm9jZXNzb3JzOnRoaXMuTixwcm9wYWdhdGlvbkNvbnRleHQ6dGhpcy5BLHNka1Byb2Nlc3NpbmdNZXRhZGF0YTp0aGlzLk8sdHJhbnNhY3Rpb25OYW1lOnRoaXMuVSxzcGFuOnd0KHRoaXMpfX1zZXRTREtQcm9jZXNzaW5nTWV0YWRhdGEodCl7cmV0dXJuIHRoaXMuTz17Li4udGhpcy5PLC4uLnR9LHRoaXN9c2V0UHJvcGFnYXRpb25Db250ZXh0KHQpe3JldHVybiB0aGlzLkE9dCx0aGlzfWdldFByb3BhZ2F0aW9uQ29udGV4dCgpe3JldHVybiB0aGlzLkF9Y2FwdHVyZUV4Y2VwdGlvbih0LG4pe2NvbnN0IGU9biYmbi5ldmVudF9pZD9uLmV2ZW50X2lkOlkoKTtpZighdGhpcy5CKXJldHVybiBrLndhcm4oIk5vIGNsaWVudCBjb25maWd1cmVkIG9uIHNjb3BlIC0gd2lsbCBub3QgY2FwdHVyZSBleGNlcHRpb24hIiksZTtjb25zdCByPW5ldyBFcnJvcigiU2VudHJ5IHN5bnRoZXRpY0V4Y2VwdGlvbiIpO3JldHVybiB0aGlzLkIuY2FwdHVyZUV4Y2VwdGlvbih0LHtvcmlnaW5hbEV4Y2VwdGlvbjp0LHN5bnRoZXRpY0V4Y2VwdGlvbjpyLC4uLm4sZXZlbnRfaWQ6ZX0sdGhpcyksZX1jYXB0dXJlTWVzc2FnZSh0LG4sZSl7Y29uc3Qgcj1lJiZlLmV2ZW50X2lkP2UuZXZlbnRfaWQ6WSgpO2lmKCF0aGlzLkIpcmV0dXJuIGsud2FybigiTm8gY2xpZW50IGNvbmZpZ3VyZWQgb24gc2NvcGUgLSB3aWxsIG5vdCBjYXB0dXJlIG1lc3NhZ2UhIikscjtjb25zdCBvPW5ldyBFcnJvcih0KTtyZXR1cm4gdGhpcy5CLmNhcHR1cmVNZXNzYWdlKHQsbix7b3JpZ2luYWxFeGNlcHRpb246dCxzeW50aGV0aWNFeGNlcHRpb246bywuLi5lLGV2ZW50X2lkOnJ9LHRoaXMpLHJ9Y2FwdHVyZUV2ZW50KHQsbil7Y29uc3QgZT1uJiZuLmV2ZW50X2lkP24uZXZlbnRfaWQ6WSgpO3JldHVybiB0aGlzLkI/KHRoaXMuQi5jYXB0dXJlRXZlbnQodCx7Li4ubixldmVudF9pZDplfSx0aGlzKSxlKTooay53YXJuKCJObyBjbGllbnQgY29uZmlndXJlZCBvbiBzY29wZSAtIHdpbGwgbm90IGNhcHR1cmUgZXZlbnQhIiksZSl9Sigpe3RoaXMudnx8KHRoaXMudj0hMCx0aGlzLlMuZm9yRWFjaCgodD0+e3QodGhpcyl9KSksdGhpcy52PSExKX19Y29uc3QgJHQ9U3Q7Y2xhc3MgRXR7Y29uc3RydWN0b3IodCxuKXtsZXQgZSxyO2U9dHx8bmV3ICR0LHI9bnx8bmV3ICR0LHRoaXMuWT1be3Njb3BlOmV9XSx0aGlzLkg9cn13aXRoU2NvcGUodCl7Y29uc3Qgbj10aGlzLlcoKTtsZXQgZTt0cnl7ZT10KG4pfWNhdGNoKHQpe3Rocm93IHRoaXMucSgpLHR9cmV0dXJuIG0oZSk/ZS50aGVuKCh0PT4odGhpcy5xKCksdCkpLCh0PT57dGhyb3cgdGhpcy5xKCksdH0pKToodGhpcy5xKCksZSl9Z2V0Q2xpZW50KCl7cmV0dXJuIHRoaXMuZ2V0U3RhY2tUb3AoKS5jbGllbnR9Z2V0U2NvcGUoKXtyZXR1cm4gdGhpcy5nZXRTdGFja1RvcCgpLnNjb3BlfWdldElzb2xhdGlvblNjb3BlKCl7cmV0dXJuIHRoaXMuSH1nZXRTdGFja1RvcCgpe3JldHVybiB0aGlzLllbdGhpcy5ZLmxlbmd0aC0xXX1XKCl7Y29uc3QgdD10aGlzLmdldFNjb3BlKCkuY2xvbmUoKTtyZXR1cm4gdGhpcy5ZLnB1c2goe2NsaWVudDp0aGlzLmdldENsaWVudCgpLHNjb3BlOnR9KSx0fXEoKXtyZXR1cm4hKHRoaXMuWS5sZW5ndGg8PTEpJiYhIXRoaXMuWS5wb3AoKX19ZnVuY3Rpb24geHQoKXtjb25zdCB0PXl0KG10KCkpO3JldHVybiB0LnN0YWNrPXQuc3RhY2t8fG5ldyBFdChfKCJkZWZhdWx0Q3VycmVudFNjb3BlIiwoKCk9Pm5ldyAkdCkpLF8oImRlZmF1bHRJc29sYXRpb25TY29wZSIsKCgpPT5uZXcgJHQpKSl9ZnVuY3Rpb24gTnQodCl7cmV0dXJuIHh0KCkud2l0aFNjb3BlKHQpfWZ1bmN0aW9uIGt0KHQsbil7Y29uc3QgZT14dCgpO3JldHVybiBlLndpdGhTY29wZSgoKCk9PihlLmdldFN0YWNrVG9wKCkuc2NvcGU9dCxuKHQpKSkpfWZ1bmN0aW9uIEN0KHQpe3JldHVybiB4dCgpLndpdGhTY29wZSgoKCk9PnQoeHQoKS5nZXRJc29sYXRpb25TY29wZSgpKSkpfWZ1bmN0aW9uIFR0KHQpe2NvbnN0IG49eXQodCk7cmV0dXJuIG4uYWNzP24uYWNzOnt3aXRoSXNvbGF0aW9uU2NvcGU6Q3Qsd2l0aFNjb3BlOk50LHdpdGhTZXRTY29wZTprdCx3aXRoU2V0SXNvbGF0aW9uU2NvcGU6KHQsbik9PkN0KG4pLGdldEN1cnJlbnRTY29wZTooKT0+eHQoKS5nZXRTY29wZSgpLGdldElzb2xhdGlvblNjb3BlOigpPT54dCgpLmdldElzb2xhdGlvblNjb3BlKCl9fWZ1bmN0aW9uIFJ0KCl7cmV0dXJuIFR0KG10KCkpLmdldEN1cnJlbnRTY29wZSgpLmdldENsaWVudCgpfWNvbnN0IER0PSJfc2VudHJ5TWV0cmljcyI7ZnVuY3Rpb24ganQodCl7Y29uc3Qgbj10W0R0XTtpZighbilyZXR1cm47Y29uc3QgZT17fTtmb3IoY29uc3RbLFt0LHJdXW9mIG4peyhlW3RdfHwoZVt0XT1bXSkpLnB1c2goTyhyKSl9cmV0dXJuIGV9Y29uc3QgT3Q9InNlbnRyeS5zb3VyY2UiLEF0PSJzZW50cnkuc2FtcGxlX3JhdGUiLEl0PSJzZW50cnkub3AiLFB0PSJzZW50cnkub3JpZ2luIixVdD0wLE10PTEsTHQ9MTtmdW5jdGlvbiBCdCh0KXtjb25zdHtzcGFuSWQ6bix0cmFjZUlkOmV9PXQuc3BhbkNvbnRleHQoKSx7cGFyZW50X3NwYW5faWQ6cn09WXQodCk7cmV0dXJuIE8oe3BhcmVudF9zcGFuX2lkOnIsc3Bhbl9pZDpuLHRyYWNlX2lkOmV9KX1mdW5jdGlvbiBHdCh0KXtyZXR1cm4ibnVtYmVyIj09dHlwZW9mIHQ/SnQodCk6QXJyYXkuaXNBcnJheSh0KT90WzBdK3RbMV0vMWU5OnQgaW5zdGFuY2VvZiBEYXRlP0p0KHQuZ2V0VGltZSgpKTpKKCl9ZnVuY3Rpb24gSnQodCl7cmV0dXJuIHQ+OTk5OTk5OTk5OT90LzFlMzp0fWZ1bmN0aW9uIFl0KHQpe2lmKGZ1bmN0aW9uKHQpe3JldHVybiJmdW5jdGlvbiI9PXR5cGVvZiB0LmdldFNwYW5KU09OfSh0KSlyZXR1cm4gdC5nZXRTcGFuSlNPTigpO3RyeXtjb25zdHtzcGFuSWQ6bix0cmFjZUlkOmV9PXQuc3BhbkNvbnRleHQoKTtpZihmdW5jdGlvbih0KXtjb25zdCBuPXQ7cmV0dXJuISEobi5hdHRyaWJ1dGVzJiZuLnN0YXJ0VGltZSYmbi5uYW1lJiZuLmVuZFRpbWUmJm4uc3RhdHVzKX0odCkpe2NvbnN0e2F0dHJpYnV0ZXM6cixzdGFydFRpbWU6byxuYW1lOnMsZW5kVGltZTppLHBhcmVudFNwYW5JZDpjLHN0YXR1czp1fT10O3JldHVybiBPKHtzcGFuX2lkOm4sdHJhY2VfaWQ6ZSxkYXRhOnIsZGVzY3JpcHRpb246cyxwYXJlbnRfc3Bhbl9pZDpjLHN0YXJ0X3RpbWVzdGFtcDpHdChvKSx0aW1lc3RhbXA6R3QoaSl8fHZvaWQgMCxzdGF0dXM6enQodSksb3A6cltJdF0sb3JpZ2luOnJbUHRdLF9tZXRyaWNzX3N1bW1hcnk6anQodCl9KX1yZXR1cm57c3Bhbl9pZDpuLHRyYWNlX2lkOmV9fWNhdGNoKHQpe3JldHVybnt9fX1mdW5jdGlvbiB6dCh0KXtpZih0JiZ0LmNvZGUhPT1VdClyZXR1cm4gdC5jb2RlPT09TXQ/Im9rIjp0Lm1lc3NhZ2V8fCJ1bmtub3duX2Vycm9yIn1jb25zdCBIdD0iX3NlbnRyeVJvb3RTcGFuIjtmdW5jdGlvbiBXdCh0KXtyZXR1cm4gdFtIdF18fHR9Y29uc3QgcXQ9InByb2R1Y3Rpb24iLEZ0PSJfZnJvemVuRHNjIjtmdW5jdGlvbiBLdCh0KXtjb25zdCBuPVJ0KCk7aWYoIW4pcmV0dXJue307Y29uc3QgZT1mdW5jdGlvbih0LG4pe2NvbnN0IGU9bi5nZXRPcHRpb25zKCkse3B1YmxpY0tleTpyfT1uLmdldERzbigpfHx7fSxvPU8oe2Vudmlyb25tZW50OmUuZW52aXJvbm1lbnR8fHF0LHJlbGVhc2U6ZS5yZWxlYXNlLHB1YmxpY19rZXk6cix0cmFjZV9pZDp0fSk7cmV0dXJuIG4uZW1pdCgiY3JlYXRlRHNjIixvKSxvfShZdCh0KS50cmFjZV9pZHx8IiIsbikscj1XdCh0KSxvPXJbRnRdO2lmKG8pcmV0dXJuIG87Y29uc3Qgcz1yLnNwYW5Db250ZXh0KCkudHJhY2VTdGF0ZSxpPXMmJnMuZ2V0KCJzZW50cnkuZHNjIiksYz1pJiZldChpKTtpZihjKXJldHVybiBjO2NvbnN0IHU9WXQociksYT11LmRhdGF8fHt9LGY9YVtBdF07bnVsbCE9ZiYmKGUuc2FtcGxlX3JhdGU9YCR7Zn1gKTtjb25zdCBoPWFbT3RdLHA9dS5kZXNjcmlwdGlvbjtyZXR1cm4idXJsIiE9PWgmJnAmJihlLnRyYW5zYWN0aW9uPXApLGZ1bmN0aW9uKHQpe2lmKCJib29sZWFuIj09dHlwZW9mIF9fU0VOVFJZX1RSQUNJTkdfXyYmIV9fU0VOVFJZX1RSQUNJTkdfXylyZXR1cm4hMTtjb25zdCBuPVJ0KCksZT10fHxuJiZuLmdldE9wdGlvbnMoKTtyZXR1cm4hIWUmJihlLmVuYWJsZVRyYWNpbmd8fCJ0cmFjZXNTYW1wbGVSYXRlImluIGV8fCJ0cmFjZXNTYW1wbGVyImluIGUpfSgpJiYoZS5zYW1wbGVkPVN0cmluZyhmdW5jdGlvbih0KXtjb25zdHt0cmFjZUZsYWdzOm59PXQuc3BhbkNvbnRleHQoKTtyZXR1cm4gbj09PUx0fShyKSkpLG4uZW1pdCgiY3JlYXRlRHNjIixlLHIpLGV9ZnVuY3Rpb24gVnQodCxuLGUscil7Y29uc3Qgbz1mdChlKSxzPXQudHlwZSYmInJlcGxheV9ldmVudCIhPT10LnR5cGU/dC50eXBlOiJldmVudCI7IWZ1bmN0aW9uKHQsbil7biYmKHQuc2RrPXQuc2RrfHx7fSx0LnNkay5uYW1lPXQuc2RrLm5hbWV8fG4ubmFtZSx0LnNkay52ZXJzaW9uPXQuc2RrLnZlcnNpb258fG4udmVyc2lvbix0LnNkay5pbnRlZ3JhdGlvbnM9Wy4uLnQuc2RrLmludGVncmF0aW9uc3x8W10sLi4ubi5pbnRlZ3JhdGlvbnN8fFtdXSx0LnNkay5wYWNrYWdlcz1bLi4udC5zZGsucGFja2FnZXN8fFtdLC4uLm4ucGFja2FnZXN8fFtdXSl9KHQsZSYmZS5zZGspO2NvbnN0IGk9ZnVuY3Rpb24odCxuLGUscil7Y29uc3Qgbz10LnNka1Byb2Nlc3NpbmdNZXRhZGF0YSYmdC5zZGtQcm9jZXNzaW5nTWV0YWRhdGEuZHluYW1pY1NhbXBsaW5nQ29udGV4dDtyZXR1cm57ZXZlbnRfaWQ6dC5ldmVudF9pZCxzZW50X2F0OihuZXcgRGF0ZSkudG9JU09TdHJpbmcoKSwuLi5uJiZ7c2RrOm59LC4uLiEhZSYmciYme2RzbjpDKHIpfSwuLi5vJiZ7dHJhY2U6Tyh7Li4ub30pfX19KHQsbyxyLG4pO2RlbGV0ZSB0LnNka1Byb2Nlc3NpbmdNZXRhZGF0YTtyZXR1cm4gb3QoaSxbW3t0eXBlOnN9LHRdXSl9Y29uc3QgWnQ9Il9fU0VOVFJZX1NVUFBSRVNTX1RSQUNJTkdfXyI7ZnVuY3Rpb24gUXQodCl7Y29uc3Qgbj1UdChtdCgpKTtyZXR1cm4gbi5zdXBwcmVzc1RyYWNpbmc/bi5zdXBwcmVzc1RyYWNpbmcodCk6ZnVuY3Rpb24oLi4udCl7Y29uc3Qgbj1UdChtdCgpKTtpZigyPT09dC5sZW5ndGgpe2NvbnN0W2Uscl09dDtyZXR1cm4gZT9uLndpdGhTZXRTY29wZShlLHIpOm4ud2l0aFNjb3BlKHIpfXJldHVybiBuLndpdGhTY29wZSh0WzBdKX0oKG49PihuLnNldFNES1Byb2Nlc3NpbmdNZXRhZGF0YSh7W1p0XTohMH0pLHQoKSkpKX1mdW5jdGlvbiBYdCh0LG4pe2NvbnN0e2ZpbmdlcnByaW50OmUsc3BhbjpyLGJyZWFkY3J1bWJzOm8sc2RrUHJvY2Vzc2luZ01ldGFkYXRhOnN9PW47IWZ1bmN0aW9uKHQsbil7Y29uc3R7ZXh0cmE6ZSx0YWdzOnIsdXNlcjpvLGNvbnRleHRzOnMsbGV2ZWw6aSx0cmFuc2FjdGlvbk5hbWU6Y309bix1PU8oZSk7dSYmT2JqZWN0LmtleXModSkubGVuZ3RoJiYodC5leHRyYT17Li4udSwuLi50LmV4dHJhfSk7Y29uc3QgYT1PKHIpO2EmJk9iamVjdC5rZXlzKGEpLmxlbmd0aCYmKHQudGFncz17Li4uYSwuLi50LnRhZ3N9KTtjb25zdCBmPU8obyk7ZiYmT2JqZWN0LmtleXMoZikubGVuZ3RoJiYodC51c2VyPXsuLi5mLC4uLnQudXNlcn0pO2NvbnN0IGg9TyhzKTtoJiZPYmplY3Qua2V5cyhoKS5sZW5ndGgmJih0LmNvbnRleHRzPXsuLi5oLC4uLnQuY29udGV4dHN9KTtpJiYodC5sZXZlbD1pKTtjJiYidHJhbnNhY3Rpb24iIT09dC50eXBlJiYodC50cmFuc2FjdGlvbj1jKX0odCxuKSxyJiZmdW5jdGlvbih0LG4pe3QuY29udGV4dHM9e3RyYWNlOkJ0KG4pLC4uLnQuY29udGV4dHN9LHQuc2RrUHJvY2Vzc2luZ01ldGFkYXRhPXtkeW5hbWljU2FtcGxpbmdDb250ZXh0Okt0KG4pLC4uLnQuc2RrUHJvY2Vzc2luZ01ldGFkYXRhfTtjb25zdCBlPVd0KG4pLHI9WXQoZSkuZGVzY3JpcHRpb247ciYmIXQudHJhbnNhY3Rpb24mJiJ0cmFuc2FjdGlvbiI9PT10LnR5cGUmJih0LnRyYW5zYWN0aW9uPXIpfSh0LHIpLGZ1bmN0aW9uKHQsbil7dC5maW5nZXJwcmludD10LmZpbmdlcnByaW50P2Z1bmN0aW9uKHQpe3JldHVybiBBcnJheS5pc0FycmF5KHQpP3Q6W3RdfSh0LmZpbmdlcnByaW50KTpbXSxuJiYodC5maW5nZXJwcmludD10LmZpbmdlcnByaW50LmNvbmNhdChuKSk7dC5maW5nZXJwcmludCYmIXQuZmluZ2VycHJpbnQubGVuZ3RoJiZkZWxldGUgdC5maW5nZXJwcmludH0odCxlKSxmdW5jdGlvbih0LG4pe2NvbnN0IGU9Wy4uLnQuYnJlYWRjcnVtYnN8fFtdLC4uLm5dO3QuYnJlYWRjcnVtYnM9ZS5sZW5ndGg/ZTp2b2lkIDB9KHQsbyksZnVuY3Rpb24odCxuKXt0LnNka1Byb2Nlc3NpbmdNZXRhZGF0YT17Li4udC5zZGtQcm9jZXNzaW5nTWV0YWRhdGEsLi4ubn19KHQscyl9Y29uc3QgdG49IjciO2Z1bmN0aW9uIG5uKHQsbil7cmV0dXJuIGU9e3NlbnRyeV9rZXk6dC5wdWJsaWNLZXksc2VudHJ5X3ZlcnNpb246dG4sLi4ubiYme3NlbnRyeV9jbGllbnQ6YCR7bi5uYW1lfS8ke24udmVyc2lvbn1gfX0sT2JqZWN0LmtleXMoZSkubWFwKCh0PT5gJHtlbmNvZGVVUklDb21wb25lbnQodCl9PSR7ZW5jb2RlVVJJQ29tcG9uZW50KGVbdF0pfWApKS5qb2luKCImIik7dmFyIGV9Y29uc3QgZW49NjQ7ZnVuY3Rpb24gcm4odCxuLGU9USh0LmJ1ZmZlclNpemV8fGVuKSl7bGV0IHI9e307cmV0dXJue3NlbmQ6ZnVuY3Rpb24obyl7Y29uc3Qgcz1bXTtpZihzdChvLCgobixlKT0+e2NvbnN0IG89YXQoZSk7aWYoZnVuY3Rpb24odCxuLGU9RGF0ZS5ub3coKSl7cmV0dXJuIGZ1bmN0aW9uKHQsbil7cmV0dXJuIHRbbl18fHQuYWxsfHwwfSh0LG4pPmV9KHIsbykpe2NvbnN0IHI9b24obixlKTt0LnJlY29yZERyb3BwZWRFdmVudCgicmF0ZWxpbWl0X2JhY2tvZmYiLG8scil9ZWxzZSBzLnB1c2gobil9KSksMD09PXMubGVuZ3RoKXJldHVybiBWKHt9KTtjb25zdCBpPW90KG9bMF0scyksYz1uPT57c3QoaSwoKGUscik9Pntjb25zdCBvPW9uKGUscik7dC5yZWNvcmREcm9wcGVkRXZlbnQobixhdChyKSxvKX0pKX07cmV0dXJuIGUuYWRkKCgoKT0+bih7Ym9keTpjdChpKX0pLnRoZW4oKHQ9Pih2b2lkIDAhPT10LnN0YXR1c0NvZGUmJih0LnN0YXR1c0NvZGU8MjAwfHx0LnN0YXR1c0NvZGU+PTMwMCkmJmR0JiZrLndhcm4oYFNlbnRyeSByZXNwb25kZWQgd2l0aCBzdGF0dXMgY29kZSAke3Quc3RhdHVzQ29kZX0gdG8gc2VudCBldmVudC5gKSxyPXB0KHIsdCksdCkpLCh0PT57dGhyb3cgYygibmV0d29ya19lcnJvciIpLHR9KSkpKS50aGVuKCh0PT50KSwodD0+e2lmKHQgaW5zdGFuY2VvZiBUKXJldHVybiBkdCYmay5lcnJvcigiU2tpcHBlZCBzZW5kaW5nIGV2ZW50IGJlY2F1c2UgYnVmZmVyIGlzIGZ1bGwuIiksYygicXVldWVfb3ZlcmZsb3ciKSxWKHt9KTt0aHJvdyB0fSkpfSxmbHVzaDp0PT5lLmRyYWluKHQpfX1mdW5jdGlvbiBvbih0LG4pe2lmKCJldmVudCI9PT1ufHwidHJhbnNhY3Rpb24iPT09bilyZXR1cm4gQXJyYXkuaXNBcnJheSh0KT90WzFdOnZvaWQgMH1jb25zdCBzbj1TeW1ib2woIkFnZW50QmFzZUludGVybmFsU3RhdGUiKTtjbGFzcyBjbiBleHRlbmRzIHMuQWdlbnR7W3NuXTtvcHRpb25zO2tlZXBBbGl2ZTtjb25zdHJ1Y3Rvcih0KXtzdXBlcih0KSx0aGlzW3NuXT17fX1pc1NlY3VyZUVuZHBvaW50KHQpe2lmKHQpe2lmKCJib29sZWFuIj09dHlwZW9mIHQuc2VjdXJlRW5kcG9pbnQpcmV0dXJuIHQuc2VjdXJlRW5kcG9pbnQ7aWYoInN0cmluZyI9PXR5cGVvZiB0LnByb3RvY29sKXJldHVybiJodHRwczoiPT09dC5wcm90b2NvbH1jb25zdHtzdGFjazpufT1uZXcgRXJyb3I7cmV0dXJuInN0cmluZyI9PXR5cGVvZiBuJiZuLnNwbGl0KCJcbiIpLnNvbWUoKHQ9Pi0xIT09dC5pbmRleE9mKCIoaHR0cHMuanM6Iil8fC0xIT09dC5pbmRleE9mKCJub2RlOmh0dHBzOiIpKSl9Y3JlYXRlU29ja2V0KHQsbixlKXtjb25zdCByPXsuLi5uLHNlY3VyZUVuZHBvaW50OnRoaXMuaXNTZWN1cmVFbmRwb2ludChuKX07UHJvbWlzZS5yZXNvbHZlKCkudGhlbigoKCk9PnRoaXMuY29ubmVjdCh0LHIpKSkudGhlbigobz0+e2lmKG8gaW5zdGFuY2VvZiBzLkFnZW50KXJldHVybiBvLmFkZFJlcXVlc3QodCxyKTt0aGlzW3NuXS5jdXJyZW50U29ja2V0PW8sc3VwZXIuY3JlYXRlU29ja2V0KHQsbixlKX0pLGUpfWNyZWF0ZUNvbm5lY3Rpb24oKXtjb25zdCB0PXRoaXNbc25dLmN1cnJlbnRTb2NrZXQ7aWYodGhpc1tzbl0uY3VycmVudFNvY2tldD12b2lkIDAsIXQpdGhyb3cgbmV3IEVycm9yKCJObyBzb2NrZXQgd2FzIHJldHVybmVkIGluIHRoZSBgY29ubmVjdCgpYCBmdW5jdGlvbiIpO3JldHVybiB0fWdldCBkZWZhdWx0UG9ydCgpe3JldHVybiB0aGlzW3NuXS5kZWZhdWx0UG9ydD8/KCJodHRwczoiPT09dGhpcy5wcm90b2NvbD80NDM6ODApfXNldCBkZWZhdWx0UG9ydCh0KXt0aGlzW3NuXSYmKHRoaXNbc25dLmRlZmF1bHRQb3J0PXQpfWdldCBwcm90b2NvbCgpe3JldHVybiB0aGlzW3NuXS5wcm90b2NvbD8/KHRoaXMuaXNTZWN1cmVFbmRwb2ludCgpPyJodHRwczoiOiJodHRwOiIpfXNldCBwcm90b2NvbCh0KXt0aGlzW3NuXSYmKHRoaXNbc25dLnByb3RvY29sPXQpfX1mdW5jdGlvbiB1biguLi50KXtrLmxvZygiW2h0dHBzLXByb3h5LWFnZW50OnBhcnNlLXByb3h5LXJlc3BvbnNlXSIsLi4udCl9ZnVuY3Rpb24gYW4odCl7cmV0dXJuIG5ldyBQcm9taXNlKCgobixlKT0+e2xldCByPTA7Y29uc3Qgbz1bXTtmdW5jdGlvbiBzKCl7Y29uc3QgYz10LnJlYWQoKTtjP2Z1bmN0aW9uKGMpe28ucHVzaChjKSxyKz1jLmxlbmd0aDtjb25zdCB1PUJ1ZmZlci5jb25jYXQobyxyKSxhPXUuaW5kZXhPZigiXHJcblxyXG4iKTtpZigtMT09PWEpcmV0dXJuIHVuKCJoYXZlIG5vdCByZWNlaXZlZCBlbmQgb2YgSFRUUCBoZWFkZXJzIHlldC4uLiIpLHZvaWQgcygpO2NvbnN0IGY9dS5zbGljZSgwLGEpLnRvU3RyaW5nKCJhc2NpaSIpLnNwbGl0KCJcclxuIiksaD1mLnNoaWZ0KCk7aWYoIWgpcmV0dXJuIHQuZGVzdHJveSgpLGUobmV3IEVycm9yKCJObyBoZWFkZXIgcmVjZWl2ZWQgZnJvbSBwcm94eSBDT05ORUNUIHJlc3BvbnNlIikpO2NvbnN0IHA9aC5zcGxpdCgiICIpLGw9KyhwWzFdfHwwKSxkPXAuc2xpY2UoMikuam9pbigiICIpLG09e307Zm9yKGNvbnN0IG4gb2YgZil7aWYoIW4pY29udGludWU7Y29uc3Qgcj1uLmluZGV4T2YoIjoiKTtpZigtMT09PXIpcmV0dXJuIHQuZGVzdHJveSgpLGUobmV3IEVycm9yKGBJbnZhbGlkIGhlYWRlciBmcm9tIHByb3h5IENPTk5FQ1QgcmVzcG9uc2U6ICIke259ImApKTtjb25zdCBvPW4uc2xpY2UoMCxyKS50b0xvd2VyQ2FzZSgpLHM9bi5zbGljZShyKzEpLnRyaW1TdGFydCgpLGk9bVtvXTsic3RyaW5nIj09dHlwZW9mIGk/bVtvXT1baSxzXTpBcnJheS5pc0FycmF5KGkpP2kucHVzaChzKTptW29dPXN9dW4oImdvdCBwcm94eSBzZXJ2ZXIgcmVzcG9uc2U6ICVvICVvIixoLG0pLGkoKSxuKHtjb25uZWN0OntzdGF0dXNDb2RlOmwsc3RhdHVzVGV4dDpkLGhlYWRlcnM6bX0sYnVmZmVyZWQ6dX0pfShjKTp0Lm9uY2UoInJlYWRhYmxlIixzKX1mdW5jdGlvbiBpKCl7dC5yZW1vdmVMaXN0ZW5lcigiZW5kIixjKSx0LnJlbW92ZUxpc3RlbmVyKCJlcnJvciIsdSksdC5yZW1vdmVMaXN0ZW5lcigicmVhZGFibGUiLHMpfWZ1bmN0aW9uIGMoKXtpKCksdW4oIm9uZW5kIiksZShuZXcgRXJyb3IoIlByb3h5IGNvbm5lY3Rpb24gZW5kZWQgYmVmb3JlIHJlY2VpdmluZyBDT05ORUNUIHJlc3BvbnNlIikpfWZ1bmN0aW9uIHUodCl7aSgpLHVuKCJvbmVycm9yICVvIix0KSxlKHQpfXQub24oImVycm9yIix1KSx0Lm9uKCJlbmQiLGMpLHMoKX0pKX1mdW5jdGlvbiBmbiguLi50KXtrLmxvZygiW2h0dHBzLXByb3h5LWFnZW50XSIsLi4udCl9Y2xhc3MgaG4gZXh0ZW5kcyBjbntzdGF0aWMgcHJvdG9jb2xzPVsiaHR0cCIsImh0dHBzIl07cHJveHk7cHJveHlIZWFkZXJzO2Nvbm5lY3RPcHRzO2NvbnN0cnVjdG9yKHQsbil7c3VwZXIobiksdGhpcy5vcHRpb25zPXt9LHRoaXMucHJveHk9InN0cmluZyI9PXR5cGVvZiB0P25ldyBVUkwodCk6dCx0aGlzLnByb3h5SGVhZGVycz1uPy5oZWFkZXJzPz97fSxmbigiQ3JlYXRpbmcgbmV3IEh0dHBzUHJveHlBZ2VudCBpbnN0YW5jZTogJW8iLHRoaXMucHJveHkuaHJlZik7Y29uc3QgZT0odGhpcy5wcm94eS5ob3N0bmFtZXx8dGhpcy5wcm94eS5ob3N0KS5yZXBsYWNlKC9eXFt8XF0kL2csIiIpLHI9dGhpcy5wcm94eS5wb3J0P3BhcnNlSW50KHRoaXMucHJveHkucG9ydCwxMCk6Imh0dHBzOiI9PT10aGlzLnByb3h5LnByb3RvY29sPzQ0Mzo4MDt0aGlzLmNvbm5lY3RPcHRzPXtBTFBOUHJvdG9jb2xzOlsiaHR0cC8xLjEiXSwuLi5uP2xuKG4sImhlYWRlcnMiKTpudWxsLGhvc3Q6ZSxwb3J0OnJ9fWFzeW5jIGNvbm5lY3QodCxuKXtjb25zdHtwcm94eTplfT10aGlzO2lmKCFuLmhvc3QpdGhyb3cgbmV3IFR5cGVFcnJvcignTm8gImhvc3QiIHByb3ZpZGVkJyk7bGV0IHI7aWYoImh0dHBzOiI9PT1lLnByb3RvY29sKXtmbigiQ3JlYXRpbmcgYHRscy5Tb2NrZXRgOiAlbyIsdGhpcy5jb25uZWN0T3B0cyk7Y29uc3QgdD10aGlzLmNvbm5lY3RPcHRzLnNlcnZlcm5hbWV8fHRoaXMuY29ubmVjdE9wdHMuaG9zdDtyPWYuY29ubmVjdCh7Li4udGhpcy5jb25uZWN0T3B0cyxzZXJ2ZXJuYW1lOnQmJmEuaXNJUCh0KT92b2lkIDA6dH0pfWVsc2UgZm4oIkNyZWF0aW5nIGBuZXQuU29ja2V0YDogJW8iLHRoaXMuY29ubmVjdE9wdHMpLHI9YS5jb25uZWN0KHRoaXMuY29ubmVjdE9wdHMpO2NvbnN0IG89ImZ1bmN0aW9uIj09dHlwZW9mIHRoaXMucHJveHlIZWFkZXJzP3RoaXMucHJveHlIZWFkZXJzKCk6ey4uLnRoaXMucHJveHlIZWFkZXJzfSxzPWEuaXNJUHY2KG4uaG9zdCk/YFske24uaG9zdH1dYDpuLmhvc3Q7bGV0IGk9YENPTk5FQ1QgJHtzfToke24ucG9ydH0gSFRUUC8xLjFcclxuYDtpZihlLnVzZXJuYW1lfHxlLnBhc3N3b3JkKXtjb25zdCB0PWAke2RlY29kZVVSSUNvbXBvbmVudChlLnVzZXJuYW1lKX06JHtkZWNvZGVVUklDb21wb25lbnQoZS5wYXNzd29yZCl9YDtvWyJQcm94eS1BdXRob3JpemF0aW9uIl09YEJhc2ljICR7QnVmZmVyLmZyb20odCkudG9TdHJpbmcoImJhc2U2NCIpfWB9by5Ib3N0PWAke3N9OiR7bi5wb3J0fWAsb1siUHJveHktQ29ubmVjdGlvbiJdfHwob1siUHJveHktQ29ubmVjdGlvbiJdPXRoaXMua2VlcEFsaXZlPyJLZWVwLUFsaXZlIjoiY2xvc2UiKTtmb3IoY29uc3QgdCBvZiBPYmplY3Qua2V5cyhvKSlpKz1gJHt0fTogJHtvW3RdfVxyXG5gO2NvbnN0IGM9YW4ocik7ci53cml0ZShgJHtpfVxyXG5gKTtjb25zdHtjb25uZWN0OnUsYnVmZmVyZWQ6aH09YXdhaXQgYztpZih0LmVtaXQoInByb3h5Q29ubmVjdCIsdSksdGhpcy5lbWl0KCJwcm94eUNvbm5lY3QiLHUsdCksMjAwPT09dS5zdGF0dXNDb2RlKXtpZih0Lm9uY2UoInNvY2tldCIscG4pLG4uc2VjdXJlRW5kcG9pbnQpe2ZuKCJVcGdyYWRpbmcgc29ja2V0IGNvbm5lY3Rpb24gdG8gVExTIik7Y29uc3QgdD1uLnNlcnZlcm5hbWV8fG4uaG9zdDtyZXR1cm4gZi5jb25uZWN0KHsuLi5sbihuLCJob3N0IiwicGF0aCIsInBvcnQiKSxzb2NrZXQ6cixzZXJ2ZXJuYW1lOmEuaXNJUCh0KT92b2lkIDA6dH0pfXJldHVybiByfXIuZGVzdHJveSgpO2NvbnN0IHA9bmV3IGEuU29ja2V0KHt3cml0YWJsZTohMX0pO3JldHVybiBwLnJlYWRhYmxlPSEwLHQub25jZSgic29ja2V0IiwodD0+e2ZuKCJSZXBsYXlpbmcgcHJveHkgYnVmZmVyIGZvciBmYWlsZWQgcmVxdWVzdCIpLHQucHVzaChoKSx0LnB1c2gobnVsbCl9KSkscH19ZnVuY3Rpb24gcG4odCl7dC5yZXN1bWUoKX1mdW5jdGlvbiBsbih0LC4uLm4pe2NvbnN0IGU9e307bGV0IHI7Zm9yKHIgaW4gdCluLmluY2x1ZGVzKHIpfHwoZVtyXT10W3JdKTtyZXR1cm4gZX1jb25zdCBkbj0zMjc2ODtmdW5jdGlvbiBtbih0KXtyZXR1cm4gdC5yZXBsYWNlKC9eW0EtWl06LywiIikucmVwbGFjZSgvXFwvZywiLyIpfWNvbnN0IHluPWU7bGV0IGduLGJuPSExO2Z1bmN0aW9uIF9uKHQpe3luLmRlYnVnJiZjb25zb2xlLmxvZyhgW0FOUiBXb3JrZXJdICR7dH1gKX12YXIgdm4sd24sU247Y29uc3QgJG49ZnVuY3Rpb24odCl7bGV0IG47dHJ5e249bmV3IFVSTCh0LnVybCl9Y2F0Y2gobil7cmV0dXJuIE4oKCgpPT57Y29uc29sZS53YXJuKCJbQHNlbnRyeS9ub2RlXTogSW52YWxpZCBkc24gb3IgdHVubmVsIG9wdGlvbiwgd2lsbCBub3Qgc2VuZCBhbnkgZXZlbnRzLiBUaGUgdHVubmVsIG9wdGlvbiBtdXN0IGJlIGEgZnVsbCBVUkwgd2hlbiB1c2VkLiIpfSkpLHJuKHQsKCgpPT5Qcm9taXNlLnJlc29sdmUoe30pKSl9Y29uc3QgZT0iaHR0cHM6Ij09PW4ucHJvdG9jb2wscj1mdW5jdGlvbih0LG4pe2NvbnN0e25vX3Byb3h5OmV9PXByb2Nlc3MuZW52O3JldHVybiBlJiZlLnNwbGl0KCIsIikuc29tZSgobj0+dC5ob3N0LmVuZHNXaXRoKG4pfHx0Lmhvc3RuYW1lLmVuZHNXaXRoKG4pKSk/dm9pZCAwOm59KG4sdC5wcm94eXx8KGU/cHJvY2Vzcy5lbnYuaHR0cHNfcHJveHk6dm9pZCAwKXx8cHJvY2Vzcy5lbnYuaHR0cF9wcm94eSksbz1lP2k6cyxhPXZvaWQgMCE9PXQua2VlcEFsaXZlJiZ0LmtlZXBBbGl2ZSxmPXI/bmV3IGhuKHIpOm5ldyBvLkFnZW50KHtrZWVwQWxpdmU6YSxtYXhTb2NrZXRzOjMwLHRpbWVvdXQ6MmUzfSksaD1mdW5jdGlvbih0LG4sZSl7Y29uc3R7aG9zdG5hbWU6cixwYXRobmFtZTpvLHBvcnQ6cyxwcm90b2NvbDppLHNlYXJjaDphfT1uZXcgVVJMKHQudXJsKTtyZXR1cm4gZnVuY3Rpb24oZil7cmV0dXJuIG5ldyBQcm9taXNlKCgoaCxwKT0+e1F0KCgoKT0+e2xldCBsPWZ1bmN0aW9uKHQpe3JldHVybiBuZXcgYyh7cmVhZCgpe3RoaXMucHVzaCh0KSx0aGlzLnB1c2gobnVsbCl9fSl9KGYuYm9keSk7Y29uc3QgZD17Li4udC5oZWFkZXJzfTtmLmJvZHkubGVuZ3RoPmRuJiYoZFsiY29udGVudC1lbmNvZGluZyJdPSJnemlwIixsPWwucGlwZSh1KCkpKTtjb25zdCBtPW4ucmVxdWVzdCh7bWV0aG9kOiJQT1NUIixhZ2VudDplLGhlYWRlcnM6ZCxob3N0bmFtZTpyLHBhdGg6YCR7b30ke2F9YCxwb3J0OnMscHJvdG9jb2w6aSxjYTp0LmNhQ2VydHN9LCh0PT57dC5vbigiZGF0YSIsKCgpPT57fSkpLHQub24oImVuZCIsKCgpPT57fSkpLHQuc2V0RW5jb2RpbmcoInV0ZjgiKTtjb25zdCBuPXQuaGVhZGVyc1sicmV0cnktYWZ0ZXIiXT8/bnVsbCxlPXQuaGVhZGVyc1sieC1zZW50cnktcmF0ZS1saW1pdHMiXT8/bnVsbDtoKHtzdGF0dXNDb2RlOnQuc3RhdHVzQ29kZSxoZWFkZXJzOnsicmV0cnktYWZ0ZXIiOm4sIngtc2VudHJ5LXJhdGUtbGltaXRzIjpBcnJheS5pc0FycmF5KGUpP2VbMF18fG51bGw6ZX19KX0pKTttLm9uKCJlcnJvciIscCksbC5waXBlKG0pfSkpfSkpfX0odCx0Lmh0dHBNb2R1bGU/P28sZik7cmV0dXJuIHJuKHQsaCl9KHt1cmw6KHZuPXluLmRzbix3bj15bi50dW5uZWwsU249eW4uc2RrTWV0YWRhdGEuc2RrLHdufHxgJHtmdW5jdGlvbih0KXtyZXR1cm5gJHtmdW5jdGlvbih0KXtjb25zdCBuPXQucHJvdG9jb2w/YCR7dC5wcm90b2NvbH06YDoiIixlPXQucG9ydD9gOiR7dC5wb3J0fWA6IiI7cmV0dXJuYCR7bn0vLyR7dC5ob3N0fSR7ZX0ke3QucGF0aD9gLyR7dC5wYXRofWA6IiJ9L2FwaS9gfSh0KX0ke3QucHJvamVjdElkfS9lbnZlbG9wZS9gfSh2bil9PyR7bm4odm4sU24pfWApLHJlY29yZERyb3BwZWRFdmVudDooKT0+e319KTthc3luYyBmdW5jdGlvbiBFbigpe2lmKGduKXtfbigiU2VuZGluZyBhYm5vcm1hbCBzZXNzaW9uIiksYnQoZ24se3N0YXR1czoiYWJub3JtYWwiLGFibm9ybWFsX21lY2hhbmlzbToiYW5yX2ZvcmVncm91bmQifSk7Y29uc3QgdD1mdW5jdGlvbih0LG4sZSxyKXtjb25zdCBvPWZ0KGUpO3JldHVybiBvdCh7c2VudF9hdDoobmV3IERhdGUpLnRvSVNPU3RyaW5nKCksLi4ubyYme3NkazpvfSwuLi4hIXImJm4mJntkc246QyhuKX19LFsiYWdncmVnYXRlcyJpbiB0P1t7dHlwZToic2Vzc2lvbnMifSx0XTpbe3R5cGU6InNlc3Npb24ifSx0LnRvSlNPTigpXV0pfShnbix5bi5kc24seW4uc2RrTWV0YWRhdGEseW4udHVubmVsKTtfbihKU09OLnN0cmluZ2lmeSh0KSksYXdhaXQgJG4uc2VuZCh0KTt0cnl7bj8ucG9zdE1lc3NhZ2UoInNlc3Npb24tZW5kZWQiKX1jYXRjaCh0KXt9fX1mdW5jdGlvbiB4bih0KXtpZighdClyZXR1cm47Y29uc3Qgbj1mdW5jdGlvbih0KXtpZighdC5sZW5ndGgpcmV0dXJuW107Y29uc3Qgbj1BcnJheS5mcm9tKHQpO3JldHVybi9zZW50cnlXcmFwcGVkLy50ZXN0KE0obikuZnVuY3Rpb258fCIiKSYmbi5wb3AoKSxuLnJldmVyc2UoKSxVLnRlc3QoTShuKS5mdW5jdGlvbnx8IiIpJiYobi5wb3AoKSxVLnRlc3QoTShuKS5mdW5jdGlvbnx8IiIpJiZuLnBvcCgpKSxuLnNsaWNlKDAsSSkubWFwKCh0PT4oey4uLnQsZmlsZW5hbWU6dC5maWxlbmFtZXx8TShuKS5maWxlbmFtZSxmdW5jdGlvbjp0LmZ1bmN0aW9ufHxQfSkpKX0odCk7aWYoeW4uYXBwUm9vdFBhdGgpZm9yKGNvbnN0IHQgb2Ygbil0LmZpbGVuYW1lJiYodC5maWxlbmFtZT1XKHQuZmlsZW5hbWUseW4uYXBwUm9vdFBhdGgpKTtyZXR1cm4gbn1hc3luYyBmdW5jdGlvbiBObih0LG4pe2lmKGJuKXJldHVybjtibj0hMCxhd2FpdCBFbigpLF9uKCJTZW5kaW5nIGV2ZW50Iik7Y29uc3QgZT17ZXZlbnRfaWQ6WSgpLGNvbnRleHRzOnluLmNvbnRleHRzLHJlbGVhc2U6eW4ucmVsZWFzZSxlbnZpcm9ubWVudDp5bi5lbnZpcm9ubWVudCxkaXN0OnluLmRpc3QscGxhdGZvcm06Im5vZGUiLGxldmVsOiJlcnJvciIsZXhjZXB0aW9uOnt2YWx1ZXM6W3t0eXBlOiJBcHBsaWNhdGlvbk5vdFJlc3BvbmRpbmciLHZhbHVlOmBBcHBsaWNhdGlvbiBOb3QgUmVzcG9uZGluZyBmb3IgYXQgbGVhc3QgJHt5bi5hbnJUaHJlc2hvbGR9IG1zYCxzdGFja3RyYWNlOntmcmFtZXM6eG4odCl9LG1lY2hhbmlzbTp7dHlwZToiQU5SIn19XX0sdGFnczp5bi5zdGF0aWNUYWdzfTtuJiZmdW5jdGlvbih0LG4pe2lmKFh0KHQsbiksIXQuY29udGV4dHM/LnRyYWNlKXtjb25zdHt0cmFjZUlkOmUsc3BhbklkOnIscGFyZW50U3BhbklkOm99PW4ucHJvcGFnYXRpb25Db250ZXh0O3QuY29udGV4dHM9e3RyYWNlOnt0cmFjZV9pZDplLHNwYW5faWQ6cixwYXJlbnRfc3Bhbl9pZDpvfSwuLi50LmNvbnRleHRzfX19KGUsbik7Y29uc3Qgcj1WdChlLHluLmRzbix5bi5zZGtNZXRhZGF0YSx5bi50dW5uZWwpO19uKEpTT04uc3RyaW5naWZ5KHIpKSxhd2FpdCAkbi5zZW5kKHIpLGF3YWl0ICRuLmZsdXNoKDJlMyksc2V0VGltZW91dCgoKCk9Pntwcm9jZXNzLmV4aXQoMCl9KSw1ZTMpfWxldCBrbjtpZihfbigiU3RhcnRlZCIpLHluLmNhcHR1cmVTdGFja1RyYWNlKXtfbigiQ29ubmVjdGluZyB0byBkZWJ1Z2dlciIpO2NvbnN0IG49bmV3IHQ7bi5jb25uZWN0VG9NYWluVGhyZWFkKCksX24oIkNvbm5lY3RlZCB0byBkZWJ1Z2dlciIpO2NvbnN0IGU9bmV3IE1hcDtuLm9uKCJEZWJ1Z2dlci5zY3JpcHRQYXJzZWQiLCh0PT57ZS5zZXQodC5wYXJhbXMuc2NyaXB0SWQsdC5wYXJhbXMudXJsKX0pKSxuLm9uKCJEZWJ1Z2dlci5wYXVzZWQiLCh0PT57aWYoIm90aGVyIj09PXQucGFyYW1zLnJlYXNvbil0cnl7X24oIkRlYnVnZ2VyIHBhdXNlZCIpO2NvbnN0IHM9Wy4uLnQucGFyYW1zLmNhbGxGcmFtZXNdLGk9eW4uYXBwUm9vdFBhdGg/ZnVuY3Rpb24odD0ocHJvY2Vzcy5hcmd2WzFdP0YocHJvY2Vzcy5hcmd2WzFdKTpwcm9jZXNzLmN3ZCgpKSxuPSJcXCI9PT1vKXtjb25zdCBlPW4/bW4odCk6dDtyZXR1cm4gdD0+e2lmKCF0KXJldHVybjtjb25zdCBvPW4/bW4odCk6dDtsZXR7ZGlyOnMsYmFzZTppLGV4dDpjfT1yLnBhcnNlKG8pOyIuanMiIT09YyYmIi5tanMiIT09YyYmIi5janMiIT09Y3x8KGk9aS5zbGljZSgwLC0xKmMubGVuZ3RoKSksc3x8KHM9Ii4iKTtjb25zdCB1PXMubGFzdEluZGV4T2YoIi9ub2RlX21vZHVsZXMiKTtpZih1Pi0xKXJldHVybmAke3Muc2xpY2UodSsxNCkucmVwbGFjZSgvXC8vZywiLiIpfToke2l9YDtpZihzLnN0YXJ0c1dpdGgoZSkpe2xldCB0PXMuc2xpY2UoZS5sZW5ndGgrMSkucmVwbGFjZSgvXC8vZywiLiIpO3JldHVybiB0JiYodCs9IjoiKSx0Kz1pLHR9cmV0dXJuIGl9fSh5bi5hcHBSb290UGF0aCk6KCk9Pnt9LGM9cy5tYXAoKHQ9PmZ1bmN0aW9uKHQsbixlKXtjb25zdCByPW4/bi5yZXBsYWNlKC9eZmlsZTpcL1wvLywiIik6dm9pZCAwLG89dC5sb2NhdGlvbi5jb2x1bW5OdW1iZXI/dC5sb2NhdGlvbi5jb2x1bW5OdW1iZXIrMTp2b2lkIDAscz10LmxvY2F0aW9uLmxpbmVOdW1iZXI/dC5sb2NhdGlvbi5saW5lTnVtYmVyKzE6dm9pZCAwO3JldHVybiBPKHtmaWxlbmFtZTpyLG1vZHVsZTplKHIpLGZ1bmN0aW9uOnQuZnVuY3Rpb25OYW1lfHxQLGNvbG5vOm8sbGluZW5vOnMsaW5fYXBwOnI/WChyKTp2b2lkIDB9KX0odCxlLmdldCh0LmxvY2F0aW9uLnNjcmlwdElkKSxpKSkpLHU9c2V0VGltZW91dCgoKCk9PntObihjKS50aGVuKG51bGwsKCgpPT57X24oIlNlbmRpbmcgQU5SIGV2ZW50IGZhaWxlZC4iKX0pKX0pLDVlMyk7bi5wb3N0KCJSdW50aW1lLmV2YWx1YXRlIix7ZXhwcmVzc2lvbjoiZ2xvYmFsLl9fU0VOVFJZX0dFVF9TQ09QRVNfXygpOyIsc2lsZW50OiEwLHJldHVybkJ5VmFsdWU6ITB9LCgodCxlKT0+e3QmJl9uKGBFcnJvciBleGVjdXRpbmcgc2NyaXB0OiAnJHt0Lm1lc3NhZ2V9J2ApLGNsZWFyVGltZW91dCh1KTtjb25zdCByPWUmJmUucmVzdWx0P2UucmVzdWx0LnZhbHVlOnZvaWQgMDtuLnBvc3QoIkRlYnVnZ2VyLnJlc3VtZSIpLG4ucG9zdCgiRGVidWdnZXIuZGlzYWJsZSIpLE5uKGMscikudGhlbihudWxsLCgoKT0+e19uKCJTZW5kaW5nIEFOUiBldmVudCBmYWlsZWQuIil9KSl9KSl9Y2F0Y2godCl7dGhyb3cgbi5wb3N0KCJEZWJ1Z2dlci5yZXN1bWUiKSxuLnBvc3QoIkRlYnVnZ2VyLmRpc2FibGUiKSx0fX0pKSxrbj0oKT0+e3RyeXtuLnBvc3QoIkRlYnVnZ2VyLmVuYWJsZSIsKCgpPT57bi5wb3N0KCJEZWJ1Z2dlci5wYXVzZSIpfSkpfWNhdGNoKHQpe319fWNvbnN0e3BvbGw6Q259PWZ1bmN0aW9uKHQsbixlLHIpe2NvbnN0IG89dCgpO2xldCBzPSExLGk9ITA7cmV0dXJuIHNldEludGVydmFsKCgoKT0+e2NvbnN0IHQ9by5nZXRUaW1lTXMoKTshMT09PXMmJnQ+bitlJiYocz0hMCxpJiZyKCkpLHQ8bitlJiYocz0hMSl9KSwyMCkse3BvbGw6KCk9PntvLnJlc2V0KCl9LGVuYWJsZWQ6dD0+e2k9dH19fSgoZnVuY3Rpb24oKXtsZXQgdD1wcm9jZXNzLmhydGltZSgpO3JldHVybntnZXRUaW1lTXM6KCk9Pntjb25zdFtuLGVdPXByb2Nlc3MuaHJ0aW1lKHQpO3JldHVybiBNYXRoLmZsb29yKDFlMypuK2UvMWU2KX0scmVzZXQ6KCk9Pnt0PXByb2Nlc3MuaHJ0aW1lKCl9fX0pLHluLnBvbGxJbnRlcnZhbCx5bi5hbnJUaHJlc2hvbGQsKGZ1bmN0aW9uKCl7X24oIldhdGNoZG9nIHRpbWVvdXQiKSxrbj8oX24oIlBhdXNpbmcgZGVidWdnZXIgdG8gY2FwdHVyZSBzdGFjayB0cmFjZSIpLGtuKCkpOihfbigiQ2FwdHVyaW5nIGV2ZW50IHdpdGhvdXQgYSBzdGFjayB0cmFjZSIpLE5uKCkudGhlbihudWxsLCgoKT0+e19uKCJTZW5kaW5nIEFOUiBldmVudCBmYWlsZWQgb24gd2F0Y2hkb2cgdGltZW91dC4iKX0pKSl9KSk7bj8ub24oIm1lc3NhZ2UiLCh0PT57dC5zZXNzaW9uJiYoZ249Z3QodC5zZXNzaW9uKSksQ24oKX0pKTs=';

const DEFAULT_INTERVAL = 50;
const DEFAULT_HANG_THRESHOLD = 5000;

function log(message, ...args) {
  utils.logger.log(`[ANR] ${message}`, ...args);
}

function globalWithScopeFetchFn() {
  return utils.GLOBAL_OBJ;
}

/** Fetches merged scope data */
function getScopeData() {
  const scope = core.getGlobalScope().getScopeData();
  core.mergeScopeData(scope, core.getIsolationScope().getScopeData());
  core.mergeScopeData(scope, core.getCurrentScope().getScopeData());

  // We remove attachments because they likely won't serialize well as json
  scope.attachments = [];
  // We can't serialize event processor functions
  scope.eventProcessors = [];

  return scope;
}

/**
 * Gets contexts by calling all event processors. This shouldn't be called until all integrations are setup
 */
async function getContexts(client) {
  let event = { message: 'ANR' };
  const eventHint = {};

  for (const processor of client.getEventProcessors()) {
    if (event === null) break;
    event = await processor(event, eventHint);
  }

  return _optionalChain([event, 'optionalAccess', _2 => _2.contexts]) || {};
}

const INTEGRATION_NAME = 'Anr';

const _anrIntegration = ((options = {}) => {
  if (nodeVersion.NODE_VERSION.major < 16 || (nodeVersion.NODE_VERSION.major === 16 && nodeVersion.NODE_VERSION.minor < 17)) {
    throw new Error('ANR detection requires Node 16.17.0 or later');
  }

  let worker;
  let client;

  // Hookup the scope fetch function to the global object so that it can be called from the worker thread via the
  // debugger when it pauses
  const gbl = globalWithScopeFetchFn();
  gbl.__SENTRY_GET_SCOPES__ = getScopeData;

  return {
    name: INTEGRATION_NAME,
    startWorker: () => {
      if (worker) {
        return;
      }

      if (client) {
        worker = _startWorker(client, options);
      }
    },
    stopWorker: () => {
      if (worker) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        worker.then(stop => {
          stop();
          worker = undefined;
        });
      }
    },
    setup(initClient) {
      client = initClient;

      // setImmediate is used to ensure that all other integrations have had their setup called first.
      // This allows us to call into all integrations to fetch the full context
      setImmediate(() => this.startWorker());
    },
  } ;
}) ;

const anrIntegration = core.defineIntegration(_anrIntegration) ;

/**
 * Starts the ANR worker thread
 *
 * @returns A function to stop the worker
 */
async function _startWorker(
  client,
  integrationOptions,
) {
  const dsn = client.getDsn();

  if (!dsn) {
    return () => {
      //
    };
  }

  const contexts = await getContexts(client);

  // These will not be accurate if sent later from the worker thread
   _optionalChainDelete([contexts, 'access', _3 => _3.app, 'optionalAccess', _4 => delete _4.app_memory]);
   _optionalChainDelete([contexts, 'access', _5 => _5.device, 'optionalAccess', _6 => delete _6.free_memory]);

  const initOptions = client.getOptions();

  const sdkMetadata = client.getSdkMetadata() || {};
  if (sdkMetadata.sdk) {
    sdkMetadata.sdk.integrations = initOptions.integrations.map(i => i.name);
  }

  const options = {
    debug: utils.logger.isEnabled(),
    dsn,
    tunnel: initOptions.tunnel,
    environment: initOptions.environment || 'production',
    release: initOptions.release,
    dist: initOptions.dist,
    sdkMetadata,
    appRootPath: integrationOptions.appRootPath,
    pollInterval: integrationOptions.pollInterval || DEFAULT_INTERVAL,
    anrThreshold: integrationOptions.anrThreshold || DEFAULT_HANG_THRESHOLD,
    captureStackTrace: !!integrationOptions.captureStackTrace,
    staticTags: integrationOptions.staticTags || {},
    contexts,
  };

  if (options.captureStackTrace) {
    const inspector = await import('node:inspector');
    if (!inspector.url()) {
      inspector.open(0);
    }
  }

  const worker = new node_worker_threads.Worker(new URL(`data:application/javascript;base64,${base64WorkerScript}`), {
    workerData: options,
    // We don't want any Node args to be passed to the worker
    execArgv: [],
  });

  process.on('exit', () => {
    // eslint-disable-next-line @typescript-eslint/no-floating-promises
    worker.terminate();
  });

  const timer = setInterval(() => {
    try {
      const currentSession = core.getCurrentScope().getSession();
      // We need to copy the session object and remove the toJSON method so it can be sent to the worker
      // serialized without making it a SerializedSession
      const session = currentSession ? { ...currentSession, toJSON: undefined } : undefined;
      // message the worker to tell it the main event loop is still running
      worker.postMessage({ session });
    } catch (_) {
      //
    }
  }, options.pollInterval);
  // Timer should not block exit
  timer.unref();

  worker.on('message', (msg) => {
    if (msg === 'session-ended') {
      log('ANR event sent from ANR worker. Clearing session in this thread.');
      core.getCurrentScope().setSession(undefined);
    }
  });

  worker.once('error', (err) => {
    clearInterval(timer);
    log('ANR worker error', err);
  });

  worker.once('exit', (code) => {
    clearInterval(timer);
    log('ANR worker exit', code);
  });

  // Ensure this thread can't block app exit
  worker.unref();

  return () => {
    // eslint-disable-next-line @typescript-eslint/no-floating-promises
    worker.terminate();
    clearInterval(timer);
  };
}

exports.anrIntegration = anrIntegration;
exports.base64WorkerScript = base64WorkerScript;
