Object.defineProperty(exports, '__esModule', { value: true });

const util = require('node:util');
const core = require('@sentry/core');
const utils = require('@sentry/utils');

const INTEGRATION_NAME = 'Console';

/**
 * Capture console logs as breadcrumbs.
 */
const consoleIntegration = core.defineIntegration(() => {
  return {
    name: INTEGRATION_NAME,
    setup(client) {
      utils.addConsoleInstrumentationHandler(({ args, level }) => {
        if (core.getClient() !== client) {
          return;
        }

        core.addBreadcrumb(
          {
            category: 'console',
            level: utils.severityLevelFromString(level),
            message: utils.truncate(util.format.apply(undefined, args), 2048), // 2KB
          },
          {
            input: [...args],
            level,
          },
        );
      });
    },
  };
});

exports.consoleIntegration = consoleIntegration;
