Object.defineProperty(exports, '__esModule', { value: true });

const instrumentationAmqplib = require('@opentelemetry/instrumentation-amqplib');
const core = require('@sentry/core');
const instrument = require('../../otel/instrument.js');
const addOriginToSpan = require('../../utils/addOriginToSpan.js');

const INTEGRATION_NAME = 'Amqplib';

const config = {
  consumeEndHook: (span) => {
    addOriginToSpan.addOriginToSpan(span, 'auto.amqplib.otel.consumer');
  },
  publishHook: (span) => {
    addOriginToSpan.addOriginToSpan(span, 'auto.amqplib.otel.publisher');
  },
};

const instrumentAmqplib = instrument.generateInstrumentOnce(INTEGRATION_NAME, () => new instrumentationAmqplib.AmqplibInstrumentation(config));

const _amqplibIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentAmqplib();
    },
  };
}) ;

const amqplibIntegration = core.defineIntegration(_amqplibIntegration);

exports.amqplibIntegration = amqplibIntegration;
exports.instrumentAmqplib = instrumentAmqplib;
