import { AmqplibInstrumentation } from '@opentelemetry/instrumentation-amqplib';
import { defineIntegration } from '@sentry/core';
import { generateInstrumentOnce } from '../../otel/instrument.js';
import { addOriginToSpan } from '../../utils/addOriginToSpan.js';

const INTEGRATION_NAME = 'Amqplib';

const config = {
  consumeEndHook: (span) => {
    addOriginToSpan(span, 'auto.amqplib.otel.consumer');
  },
  publishHook: (span) => {
    addOriginToSpan(span, 'auto.amqplib.otel.publisher');
  },
};

const instrumentAmqplib = generateInstrumentOnce(INTEGRATION_NAME, () => new AmqplibInstrumentation(config));

const _amqplibIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentAmqplib();
    },
  };
}) ;

const amqplibIntegration = defineIntegration(_amqplibIntegration);

export { amqplibIntegration, instrumentAmqplib };
