Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./integrations/http/index.js');
const nodeFetch = require('./integrations/node-fetch.js');
const fs = require('./integrations/fs.js');
const console = require('./integrations/console.js');
const context = require('./integrations/context.js');
const contextlines = require('./integrations/contextlines.js');
const index$1 = require('./integrations/local-variables/index.js');
const modules = require('./integrations/modules.js');
const onuncaughtexception = require('./integrations/onuncaughtexception.js');
const onunhandledrejection = require('./integrations/onunhandledrejection.js');
const index$2 = require('./integrations/anr/index.js');
const express = require('./integrations/tracing/express.js');
const fastify = require('./integrations/tracing/fastify.js');
const graphql = require('./integrations/tracing/graphql.js');
const kafka = require('./integrations/tracing/kafka.js');
const lrumemoizer = require('./integrations/tracing/lrumemoizer.js');
const mongo = require('./integrations/tracing/mongo.js');
const mongoose = require('./integrations/tracing/mongoose.js');
const mysql = require('./integrations/tracing/mysql.js');
const mysql2 = require('./integrations/tracing/mysql2.js');
const redis = require('./integrations/tracing/redis.js');
const nest = require('./integrations/tracing/nest/nest.js');
const postgres = require('./integrations/tracing/postgres.js');
const prisma = require('./integrations/tracing/prisma.js');
const index$3 = require('./integrations/tracing/hapi/index.js');
const koa = require('./integrations/tracing/koa.js');
const connect = require('./integrations/tracing/connect.js');
const spotlight = require('./integrations/spotlight.js');
const genericPool = require('./integrations/tracing/genericPool.js');
const dataloader = require('./integrations/tracing/dataloader.js');
const amqplib = require('./integrations/tracing/amqplib.js');
const contextManager = require('./otel/contextManager.js');
const instrument = require('./otel/instrument.js');
const index$4 = require('./sdk/index.js');
const initOtel = require('./sdk/initOtel.js');
const index$5 = require('./integrations/tracing/index.js');
const api = require('./sdk/api.js');
const module$1 = require('./utils/module.js');
const http = require('./transports/http.js');
const client = require('./sdk/client.js');
const index$6 = require('./cron/index.js');
const utils = require('@sentry/utils');
const opentelemetry = require('@sentry/opentelemetry');
const core = require('@sentry/core');



exports.httpIntegration = index.httpIntegration;
exports.nativeNodeFetchIntegration = nodeFetch.nativeNodeFetchIntegration;
exports.fsIntegration = fs.fsIntegration;
exports.consoleIntegration = console.consoleIntegration;
exports.nodeContextIntegration = context.nodeContextIntegration;
exports.contextLinesIntegration = contextlines.contextLinesIntegration;
exports.localVariablesIntegration = index$1.localVariablesIntegration;
exports.modulesIntegration = modules.modulesIntegration;
exports.onUncaughtExceptionIntegration = onuncaughtexception.onUncaughtExceptionIntegration;
exports.onUnhandledRejectionIntegration = onunhandledrejection.onUnhandledRejectionIntegration;
exports.anrIntegration = index$2.anrIntegration;
exports.expressErrorHandler = express.expressErrorHandler;
exports.expressIntegration = express.expressIntegration;
exports.setupExpressErrorHandler = express.setupExpressErrorHandler;
exports.fastifyIntegration = fastify.fastifyIntegration;
exports.setupFastifyErrorHandler = fastify.setupFastifyErrorHandler;
exports.graphqlIntegration = graphql.graphqlIntegration;
exports.kafkaIntegration = kafka.kafkaIntegration;
exports.lruMemoizerIntegration = lrumemoizer.lruMemoizerIntegration;
exports.mongoIntegration = mongo.mongoIntegration;
exports.mongooseIntegration = mongoose.mongooseIntegration;
exports.mysqlIntegration = mysql.mysqlIntegration;
exports.mysql2Integration = mysql2.mysql2Integration;
exports.redisIntegration = redis.redisIntegration;
exports.nestIntegration = nest.nestIntegration;
exports.setupNestErrorHandler = nest.setupNestErrorHandler;
exports.postgresIntegration = postgres.postgresIntegration;
exports.prismaIntegration = prisma.prismaIntegration;
exports.hapiIntegration = index$3.hapiIntegration;
exports.setupHapiErrorHandler = index$3.setupHapiErrorHandler;
exports.koaIntegration = koa.koaIntegration;
exports.setupKoaErrorHandler = koa.setupKoaErrorHandler;
exports.connectIntegration = connect.connectIntegration;
exports.setupConnectErrorHandler = connect.setupConnectErrorHandler;
exports.spotlightIntegration = spotlight.spotlightIntegration;
exports.genericPoolIntegration = genericPool.genericPoolIntegration;
exports.dataloaderIntegration = dataloader.dataloaderIntegration;
exports.amqplibIntegration = amqplib.amqplibIntegration;
exports.SentryContextManager = contextManager.SentryContextManager;
exports.generateInstrumentOnce = instrument.generateInstrumentOnce;
exports.getDefaultIntegrations = index$4.getDefaultIntegrations;
exports.getDefaultIntegrationsWithoutPerformance = index$4.getDefaultIntegrationsWithoutPerformance;
exports.init = index$4.init;
exports.initWithoutDefaultIntegrations = index$4.initWithoutDefaultIntegrations;
exports.validateOpenTelemetrySetup = index$4.validateOpenTelemetrySetup;
exports.initOpenTelemetry = initOtel.initOpenTelemetry;
exports.preloadOpenTelemetry = initOtel.preloadOpenTelemetry;
exports.getAutoPerformanceIntegrations = index$5.getAutoPerformanceIntegrations;
exports.defaultStackParser = api.defaultStackParser;
exports.getSentryRelease = api.getSentryRelease;
exports.createGetModuleFromFilename = module$1.createGetModuleFromFilename;
exports.makeNodeTransport = http.makeNodeTransport;
exports.NodeClient = client.NodeClient;
exports.cron = index$6.cron;
exports.DEFAULT_USER_INCLUDES = utils.DEFAULT_USER_INCLUDES;
exports.addRequestDataToEvent = utils.addRequestDataToEvent;
exports.extractRequestData = utils.extractRequestData;
exports.addOpenTelemetryInstrumentation = opentelemetry.addOpenTelemetryInstrumentation;
exports.continueTrace = opentelemetry.continueTrace;
exports.setNodeAsyncContextStrategy = opentelemetry.setOpenTelemetryContextAsyncContextStrategy;
exports.SDK_VERSION = core.SDK_VERSION;
exports.SEMANTIC_ATTRIBUTE_SENTRY_OP = core.SEMANTIC_ATTRIBUTE_SENTRY_OP;
exports.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = core.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = core.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = core.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureConsoleIntegration = core.captureConsoleIntegration;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureFeedback = core.captureFeedback;
exports.captureMessage = core.captureMessage;
exports.captureSession = core.captureSession;
exports.close = core.close;
exports.createTransport = core.createTransport;
exports.debugIntegration = core.debugIntegration;
exports.dedupeIntegration = core.dedupeIntegration;
exports.endSession = core.endSession;
exports.extraErrorDataIntegration = core.extraErrorDataIntegration;
exports.flush = core.flush;
exports.functionToStringIntegration = core.functionToStringIntegration;
exports.getActiveSpan = core.getActiveSpan;
exports.getClient = core.getClient;
exports.getCurrentHub = core.getCurrentHub;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getIsolationScope = core.getIsolationScope;
exports.getRootSpan = core.getRootSpan;
exports.getSpanDescendants = core.getSpanDescendants;
exports.getSpanStatusFromHttpCode = core.getSpanStatusFromHttpCode;
exports.getTraceData = core.getTraceData;
exports.getTraceMetaTags = core.getTraceMetaTags;
exports.inboundFiltersIntegration = core.inboundFiltersIntegration;
exports.isInitialized = core.isInitialized;
exports.lastEventId = core.lastEventId;
exports.linkedErrorsIntegration = core.linkedErrorsIntegration;
exports.metrics = core.metricsDefault;
exports.parameterize = core.parameterize;
exports.profiler = core.profiler;
exports.requestDataIntegration = core.requestDataIntegration;
exports.rewriteFramesIntegration = core.rewriteFramesIntegration;
exports.sessionTimingIntegration = core.sessionTimingIntegration;
exports.setContext = core.setContext;
exports.setCurrentClient = core.setCurrentClient;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setHttpStatus = core.setHttpStatus;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanToBaggageHeader = core.spanToBaggageHeader;
exports.spanToJSON = core.spanToJSON;
exports.spanToTraceHeader = core.spanToTraceHeader;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startNewTrace = core.startNewTrace;
exports.startSession = core.startSession;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.suppressTracing = core.suppressTracing;
exports.trpcMiddleware = core.trpcMiddleware;
exports.withActiveSpan = core.withActiveSpan;
exports.withIsolationScope = core.withIsolationScope;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.zodErrorsIntegration = core.zodErrorsIntegration;
