import { LruMemoizerInstrumentation } from '@opentelemetry/instrumentation-lru-memoizer';
import { defineIntegration } from '@sentry/core';
import { generateInstrumentOnce } from '../../otel/instrument.js';

const INTEGRATION_NAME = 'LruMemoizer';

const instrumentLruMemoizer = generateInstrumentOnce(INTEGRATION_NAME, () => new LruMemoizerInstrumentation());

const _lruMemoizerIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentLruMemoizer();
    },
  };
}) ;

/**
 * LruMemoizer integration
 *
 * Propagate traces through LruMemoizer.
 */
const lruMemoizerIntegration = defineIntegration(_lruMemoizerIntegration);

export { instrumentLruMemoizer, lruMemoizerIntegration };
