Object.defineProperty(exports, '__esModule', { value: true });

const breadcrumbs = require('./breadcrumbs.js');
const currentScopes = require('./currentScopes.js');
const exports$1 = require('./exports.js');

/**
 * This is for legacy reasons, and returns a proxy object instead of a hub to be used.
 *
 * @deprecated Use the methods directly from the top level Sentry API (e.g. `Sentry.withScope`)
 * For more information see our migration guide for
 * [replacing `getCurrentHub` and `Hub`](https://github.com/getsentry/sentry-javascript/blob/develop/MIGRATION.md#deprecate-hub)
 * usage
 */
// eslint-disable-next-line deprecation/deprecation
function getCurrentHubShim() {
  return {
    bindClient(client) {
      const scope = currentScopes.getCurrentScope();
      scope.setClient(client);
    },

    withScope: currentScopes.withScope,
    getClient: () => currentScopes.getClient() ,
    getScope: currentScopes.getCurrentScope,
    getIsolationScope: currentScopes.getIsolationScope,
    captureException: (exception, hint) => {
      return currentScopes.getCurrentScope().captureException(exception, hint);
    },
    captureMessage: (message, level, hint) => {
      return currentScopes.getCurrentScope().captureMessage(message, level, hint);
    },
    captureEvent: exports$1.captureEvent,
    addBreadcrumb: breadcrumbs.addBreadcrumb,
    setUser: exports$1.setUser,
    setTags: exports$1.setTags,
    setTag: exports$1.setTag,
    setExtra: exports$1.setExtra,
    setExtras: exports$1.setExtras,
    setContext: exports$1.setContext,

    getIntegration(integration) {
      const client = currentScopes.getClient();
      return (client && client.getIntegrationByName(integration.id)) || null;
    },

    startSession: exports$1.startSession,
    endSession: exports$1.endSession,
    captureSession(end) {
      // both send the update and pull the session from the scope
      if (end) {
        return exports$1.endSession();
      }

      // only send the update
      _sendSessionUpdate();
    },
  };
}

/**
 * Returns the default hub instance.
 *
 * If a hub is already registered in the global carrier but this module
 * contains a more recent version, it replaces the registered version.
 * Otherwise, the currently registered hub will be returned.
 *
 * @deprecated Use the respective replacement method directly instead.
 */
// eslint-disable-next-line deprecation/deprecation
const getCurrentHub = getCurrentHubShim;

/**
 * Sends the current Session on the scope
 */
function _sendSessionUpdate() {
  const scope = currentScopes.getCurrentScope();
  const client = currentScopes.getClient();

  const session = scope.getSession();
  if (client && session) {
    client.captureSession(session);
  }
}

exports.getCurrentHub = getCurrentHub;
exports.getCurrentHubShim = getCurrentHubShim;
