Object.defineProperty(exports, '__esModule', { value: true });

const errors = require('./tracing/errors.js');
const utils$1 = require('./tracing/utils.js');
const hubextensions = require('./tracing/hubextensions.js');
const idleSpan = require('./tracing/idleSpan.js');
const sentrySpan = require('./tracing/sentrySpan.js');
const sentryNonRecordingSpan = require('./tracing/sentryNonRecordingSpan.js');
const spanstatus = require('./tracing/spanstatus.js');
const trace = require('./tracing/trace.js');
const dynamicSamplingContext = require('./tracing/dynamicSamplingContext.js');
const measurement = require('./tracing/measurement.js');
const sampling = require('./tracing/sampling.js');
const logSpans = require('./tracing/logSpans.js');
const semanticAttributes = require('./semanticAttributes.js');
const envelope = require('./envelope.js');
const exports$1 = require('./exports.js');
const currentScopes = require('./currentScopes.js');
const defaultScopes = require('./defaultScopes.js');
const index = require('./asyncContext/index.js');
const carrier = require('./carrier.js');
const session = require('./session.js');
const sessionflusher = require('./sessionflusher.js');
const scope = require('./scope.js');
const eventProcessors = require('./eventProcessors.js');
const api = require('./api.js');
const baseclient = require('./baseclient.js');
const serverRuntimeClient = require('./server-runtime-client.js');
const sdk = require('./sdk.js');
const base = require('./transports/base.js');
const offline = require('./transports/offline.js');
const multiplexed = require('./transports/multiplexed.js');
const integration = require('./integration.js');
const applyScopeDataToEvent = require('./utils/applyScopeDataToEvent.js');
const prepareEvent = require('./utils/prepareEvent.js');
const checkin = require('./checkin.js');
const hasTracingEnabled = require('./utils/hasTracingEnabled.js');
const isSentryRequestUrl = require('./utils/isSentryRequestUrl.js');
const handleCallbackErrors = require('./utils/handleCallbackErrors.js');
const parameterize = require('./utils/parameterize.js');
const spanUtils = require('./utils/spanUtils.js');
const parseSampleRate = require('./utils/parseSampleRate.js');
const sdkMetadata = require('./utils/sdkMetadata.js');
const traceData = require('./utils/traceData.js');
const meta = require('./utils/meta.js');
const constants = require('./constants.js');
const breadcrumbs = require('./breadcrumbs.js');
const functiontostring = require('./integrations/functiontostring.js');
const inboundfilters = require('./integrations/inboundfilters.js');
const linkederrors = require('./integrations/linkederrors.js');
const metadata = require('./integrations/metadata.js');
const requestdata = require('./integrations/requestdata.js');
const captureconsole = require('./integrations/captureconsole.js');
const debug = require('./integrations/debug.js');
const dedupe = require('./integrations/dedupe.js');
const extraerrordata = require('./integrations/extraerrordata.js');
const rewriteframes = require('./integrations/rewriteframes.js');
const sessiontiming = require('./integrations/sessiontiming.js');
const zoderrors = require('./integrations/zoderrors.js');
const thirdPartyErrorsFilter = require('./integrations/third-party-errors-filter.js');
const exports$2 = require('./metrics/exports.js');
const profiling = require('./profiling.js');
const exportsDefault = require('./metrics/exports-default.js');
const browserAggregator = require('./metrics/browser-aggregator.js');
const metricSummary = require('./metrics/metric-summary.js');
const fetch = require('./fetch.js');
const trpc = require('./trpc.js');
const feedback = require('./feedback.js');
const getCurrentHubShim = require('./getCurrentHubShim.js');
const utils = require('@sentry/utils');



exports.registerSpanErrorInstrumentation = errors.registerSpanErrorInstrumentation;
exports.getCapturedScopesOnSpan = utils$1.getCapturedScopesOnSpan;
exports.setCapturedScopesOnSpan = utils$1.setCapturedScopesOnSpan;
exports.addTracingExtensions = hubextensions.addTracingExtensions;
exports.TRACING_DEFAULTS = idleSpan.TRACING_DEFAULTS;
exports.startIdleSpan = idleSpan.startIdleSpan;
exports.SentrySpan = sentrySpan.SentrySpan;
exports.SentryNonRecordingSpan = sentryNonRecordingSpan.SentryNonRecordingSpan;
exports.SPAN_STATUS_ERROR = spanstatus.SPAN_STATUS_ERROR;
exports.SPAN_STATUS_OK = spanstatus.SPAN_STATUS_OK;
exports.SPAN_STATUS_UNSET = spanstatus.SPAN_STATUS_UNSET;
exports.getSpanStatusFromHttpCode = spanstatus.getSpanStatusFromHttpCode;
exports.setHttpStatus = spanstatus.setHttpStatus;
exports.continueTrace = trace.continueTrace;
exports.startInactiveSpan = trace.startInactiveSpan;
exports.startNewTrace = trace.startNewTrace;
exports.startSpan = trace.startSpan;
exports.startSpanManual = trace.startSpanManual;
exports.suppressTracing = trace.suppressTracing;
exports.withActiveSpan = trace.withActiveSpan;
exports.getDynamicSamplingContextFromClient = dynamicSamplingContext.getDynamicSamplingContextFromClient;
exports.getDynamicSamplingContextFromSpan = dynamicSamplingContext.getDynamicSamplingContextFromSpan;
exports.spanToBaggageHeader = dynamicSamplingContext.spanToBaggageHeader;
exports.setMeasurement = measurement.setMeasurement;
exports.timedEventsToMeasurements = measurement.timedEventsToMeasurements;
exports.sampleSpan = sampling.sampleSpan;
exports.logSpanEnd = logSpans.logSpanEnd;
exports.logSpanStart = logSpans.logSpanStart;
exports.SEMANTIC_ATTRIBUTE_CACHE_HIT = semanticAttributes.SEMANTIC_ATTRIBUTE_CACHE_HIT;
exports.SEMANTIC_ATTRIBUTE_CACHE_ITEM_SIZE = semanticAttributes.SEMANTIC_ATTRIBUTE_CACHE_ITEM_SIZE;
exports.SEMANTIC_ATTRIBUTE_CACHE_KEY = semanticAttributes.SEMANTIC_ATTRIBUTE_CACHE_KEY;
exports.SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME = semanticAttributes.SEMANTIC_ATTRIBUTE_EXCLUSIVE_TIME;
exports.SEMANTIC_ATTRIBUTE_HTTP_REQUEST_METHOD = semanticAttributes.SEMANTIC_ATTRIBUTE_HTTP_REQUEST_METHOD;
exports.SEMANTIC_ATTRIBUTE_PROFILE_ID = semanticAttributes.SEMANTIC_ATTRIBUTE_PROFILE_ID;
exports.SEMANTIC_ATTRIBUTE_SENTRY_IDLE_SPAN_FINISH_REASON = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_IDLE_SPAN_FINISH_REASON;
exports.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_UNIT;
exports.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_MEASUREMENT_VALUE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_OP = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_OP;
exports.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_SAMPLE_RATE;
exports.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE = semanticAttributes.SEMANTIC_ATTRIBUTE_SENTRY_SOURCE;
exports.SEMANTIC_ATTRIBUTE_URL_FULL = semanticAttributes.SEMANTIC_ATTRIBUTE_URL_FULL;
exports.createEventEnvelope = envelope.createEventEnvelope;
exports.createSessionEnvelope = envelope.createSessionEnvelope;
exports.createSpanEnvelope = envelope.createSpanEnvelope;
exports.addEventProcessor = exports$1.addEventProcessor;
exports.captureCheckIn = exports$1.captureCheckIn;
exports.captureEvent = exports$1.captureEvent;
exports.captureException = exports$1.captureException;
exports.captureMessage = exports$1.captureMessage;
exports.captureSession = exports$1.captureSession;
exports.close = exports$1.close;
exports.endSession = exports$1.endSession;
exports.flush = exports$1.flush;
exports.isEnabled = exports$1.isEnabled;
exports.isInitialized = exports$1.isInitialized;
exports.lastEventId = exports$1.lastEventId;
exports.setContext = exports$1.setContext;
exports.setExtra = exports$1.setExtra;
exports.setExtras = exports$1.setExtras;
exports.setTag = exports$1.setTag;
exports.setTags = exports$1.setTags;
exports.setUser = exports$1.setUser;
exports.startSession = exports$1.startSession;
exports.withMonitor = exports$1.withMonitor;
exports.getClient = currentScopes.getClient;
exports.getCurrentScope = currentScopes.getCurrentScope;
exports.getGlobalScope = currentScopes.getGlobalScope;
exports.getIsolationScope = currentScopes.getIsolationScope;
exports.withIsolationScope = currentScopes.withIsolationScope;
exports.withScope = currentScopes.withScope;
exports.getDefaultCurrentScope = defaultScopes.getDefaultCurrentScope;
exports.getDefaultIsolationScope = defaultScopes.getDefaultIsolationScope;
exports.setAsyncContextStrategy = index.setAsyncContextStrategy;
exports.getMainCarrier = carrier.getMainCarrier;
exports.closeSession = session.closeSession;
exports.makeSession = session.makeSession;
exports.updateSession = session.updateSession;
exports.SessionFlusher = sessionflusher.SessionFlusher;
exports.Scope = scope.Scope;
exports.notifyEventProcessors = eventProcessors.notifyEventProcessors;
exports.getEnvelopeEndpointWithUrlEncodedAuth = api.getEnvelopeEndpointWithUrlEncodedAuth;
exports.getReportDialogEndpoint = api.getReportDialogEndpoint;
exports.BaseClient = baseclient.BaseClient;
exports.ServerRuntimeClient = serverRuntimeClient.ServerRuntimeClient;
exports.initAndBind = sdk.initAndBind;
exports.setCurrentClient = sdk.setCurrentClient;
exports.createTransport = base.createTransport;
exports.makeOfflineTransport = offline.makeOfflineTransport;
exports.makeMultiplexedTransport = multiplexed.makeMultiplexedTransport;
exports.addIntegration = integration.addIntegration;
exports.defineIntegration = integration.defineIntegration;
exports.getIntegrationsToSetup = integration.getIntegrationsToSetup;
exports.applyScopeDataToEvent = applyScopeDataToEvent.applyScopeDataToEvent;
exports.mergeScopeData = applyScopeDataToEvent.mergeScopeData;
exports.prepareEvent = prepareEvent.prepareEvent;
exports.createCheckInEnvelope = checkin.createCheckInEnvelope;
exports.hasTracingEnabled = hasTracingEnabled.hasTracingEnabled;
exports.isSentryRequestUrl = isSentryRequestUrl.isSentryRequestUrl;
exports.handleCallbackErrors = handleCallbackErrors.handleCallbackErrors;
exports.parameterize = parameterize.parameterize;
exports.addChildSpanToSpan = spanUtils.addChildSpanToSpan;
exports.getActiveSpan = spanUtils.getActiveSpan;
exports.getRootSpan = spanUtils.getRootSpan;
exports.getSpanDescendants = spanUtils.getSpanDescendants;
exports.getStatusMessage = spanUtils.getStatusMessage;
exports.spanIsSampled = spanUtils.spanIsSampled;
exports.spanTimeInputToSeconds = spanUtils.spanTimeInputToSeconds;
exports.spanToJSON = spanUtils.spanToJSON;
exports.spanToTraceContext = spanUtils.spanToTraceContext;
exports.spanToTraceHeader = spanUtils.spanToTraceHeader;
exports.parseSampleRate = parseSampleRate.parseSampleRate;
exports.applySdkMetadata = sdkMetadata.applySdkMetadata;
exports.getTraceData = traceData.getTraceData;
exports.getTraceMetaTags = meta.getTraceMetaTags;
exports.DEFAULT_ENVIRONMENT = constants.DEFAULT_ENVIRONMENT;
exports.addBreadcrumb = breadcrumbs.addBreadcrumb;
exports.functionToStringIntegration = functiontostring.functionToStringIntegration;
exports.inboundFiltersIntegration = inboundfilters.inboundFiltersIntegration;
exports.linkedErrorsIntegration = linkederrors.linkedErrorsIntegration;
exports.moduleMetadataIntegration = metadata.moduleMetadataIntegration;
exports.requestDataIntegration = requestdata.requestDataIntegration;
exports.captureConsoleIntegration = captureconsole.captureConsoleIntegration;
exports.debugIntegration = debug.debugIntegration;
exports.dedupeIntegration = dedupe.dedupeIntegration;
exports.extraErrorDataIntegration = extraerrordata.extraErrorDataIntegration;
exports.rewriteFramesIntegration = rewriteframes.rewriteFramesIntegration;
exports.sessionTimingIntegration = sessiontiming.sessionTimingIntegration;
exports.zodErrorsIntegration = zoderrors.zodErrorsIntegration;
exports.thirdPartyErrorFilterIntegration = thirdPartyErrorsFilter.thirdPartyErrorFilterIntegration;
exports.metrics = exports$2.metrics;
exports.profiler = profiling.profiler;
exports.metricsDefault = exportsDefault.metricsDefault;
exports.BrowserMetricsAggregator = browserAggregator.BrowserMetricsAggregator;
exports.getMetricSummaryJsonForSpan = metricSummary.getMetricSummaryJsonForSpan;
exports.addTracingHeadersToFetchRequest = fetch.addTracingHeadersToFetchRequest;
exports.instrumentFetchRequest = fetch.instrumentFetchRequest;
exports.trpcMiddleware = trpc.trpcMiddleware;
exports.captureFeedback = feedback.captureFeedback;
exports.getCurrentHub = getCurrentHubShim.getCurrentHub;
exports.getCurrentHubShim = getCurrentHubShim.getCurrentHubShim;
exports.SDK_VERSION = utils.SDK_VERSION;
