Object.defineProperty(exports, '__esModule', { value: true });

const instrumentationGenericPool = require('@opentelemetry/instrumentation-generic-pool');
const core = require('@sentry/core');
const instrument = require('../../otel/instrument.js');

const INTEGRATION_NAME = 'GenericPool';

const instrumentGenericPool = instrument.generateInstrumentOnce(INTEGRATION_NAME, () => new instrumentationGenericPool.GenericPoolInstrumentation({}));

const _genericPoolIntegration = (() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentGenericPool();
    },

    setup(client) {
      client.on('spanStart', span => {
        const spanJSON = core.spanToJSON(span);

        const spanDescription = spanJSON.description;

        // typo in emitted span for version <= 0.38.0 of @opentelemetry/instrumentation-generic-pool
        const isGenericPoolSpan =
          spanDescription === 'generic-pool.aquire' || spanDescription === 'generic-pool.acquire';

        if (isGenericPoolSpan) {
          span.setAttribute(core.SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN, 'auto.db.otel.generic_pool');
        }
      });
    },
  };
}) ;

/**
 * GenericPool integration
 *
 * Capture tracing data for GenericPool.
 */
const genericPoolIntegration = core.defineIntegration(_genericPoolIntegration);

exports.genericPoolIntegration = genericPoolIntegration;
exports.instrumentGenericPool = instrumentGenericPool;
